% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eth.R
\name{eth_getTransactionByBlockHashAndIndex}
\alias{eth_getTransactionByBlockHashAndIndex}
\title{Transaction information given a block hash and an index position.}
\usage{
eth_getTransactionByBlockHashAndIndex(block_hash, trans_index,
  hex = TRUE)
}
\arguments{
\item{block_hash}{Hash - Hash of a block.}

\item{trans_index}{Integer - Transaction index position.}

\item{hex}{Boolean - \code{true} to get the response in hexadecimal,
\code{false} to get a readable response.}
}
\value{
Object - A transaction object, or \cite{null} when no transaction was
  found.
}
\description{
\code{eth_getTransactionByBlockHashAndIndex} returns information about a
transaction by block hash and transaction index position.
}
\examples{
\donttest{
eth_getTransactionByBlockHashAndIndex('0xb69e76f3997f318f4385f31885576aa43cb
40ad4ed8938718e150320ff48f528', 0)
eth_getTransactionByBlockHashAndIndex('0x9f965e1d082ffe457247befe92089d8fc2e
63015c12f373bd0d61d3ab76c6d05', 10, FALSE)
}

}
\seealso{
Other eth functions: \code{\link{eth_accounts}},
  \code{\link{eth_blockNumber}}, \code{\link{eth_call}},
  \code{\link{eth_coinbase}},
  \code{\link{eth_estimateGas}},
  \code{\link{eth_gasPrice}}, \code{\link{eth_getBalance}},
  \code{\link{eth_getBlockByHash}},
  \code{\link{eth_getBlockByNumber}},
  \code{\link{eth_getBlockTransactionCountByHash}},
  \code{\link{eth_getBlockTransactionCountByNumber}},
  \code{\link{eth_getCode}},
  \code{\link{eth_getFilterChanges}},
  \code{\link{eth_getFilterLogs}},
  \code{\link{eth_getLogs}}, \code{\link{eth_getProof}},
  \code{\link{eth_getStorageAt}},
  \code{\link{eth_getTransactionByBlockNumberAndIndex}},
  \code{\link{eth_getTransactionByHash}},
  \code{\link{eth_getTransactionCount}},
  \code{\link{eth_getTransactionReceipt}},
  \code{\link{eth_getUncleByBlockHashAndIndex}},
  \code{\link{eth_getUncleByBlockNumberAndIndex}},
  \code{\link{eth_getUncleCountByBlockHash}},
  \code{\link{eth_getUncleCountByBlockNumber}},
  \code{\link{eth_getWork}}, \code{\link{eth_hashrate}},
  \code{\link{eth_mining}},
  \code{\link{eth_newBlockFilter}},
  \code{\link{eth_newFilter}},
  \code{\link{eth_newPendingTransactionFilter}},
  \code{\link{eth_protocolVersion}},
  \code{\link{eth_sendRawTransaction}},
  \code{\link{eth_sendTransaction}},
  \code{\link{eth_sign}}, \code{\link{eth_submitHashrate}},
  \code{\link{eth_submitWork}}, \code{\link{eth_syncing}},
  \code{\link{eth_uninstallFilter}}, \code{\link{gethr}},
  \code{\link{personal_sendTransaction}}
}
\concept{eth functions}
