% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histories.R
\name{make_histories}
\alias{make_histories}
\title{Generates Functions of History of Existing Covariates}
\usage{
make_histories(pool, histvars, histvals, histories, time_name, t, id,
  max_visits, baselags)
}
\arguments{
\item{pool}{Data table containing all information prior to time \eqn{t} (\eqn{t} noninclusive).}

\item{histvars}{List of vectors. The kth vector specifies the names of the variables for which the kth history function
in \code{histories} is to be applied.}

\item{histvals}{List of length two. The first element is a numeric vector specifying the lags used in the model statements (e.g., if \code{lag1_varname} and \code{lag2_varname} were included in the model statements, this vector would be \code{c(1,2)}). The second element is a numeric vector specifying the lag averages used in the model statements.}

\item{histories}{Vector of history functions to apply to the variables specified in \code{histvars}.}

\item{time_name}{Character string specifying the name of the time variable in \code{pool}.}

\item{t}{Integer specifying the current time index.}

\item{id}{Character string specifying the name of the ID variable in \code{pool}.}

\item{max_visits}{A vector of one or more values denoting the maximum number of times
a binary covariate representing a visit process may be missed before
the individual is censored from the data (in the observed data) or
a visit is forced (in the simulated data). Multiple values exist in the
vector when the modeling of more than covariate is attached to a visit
process. A value of \code{NA} should be provided when there is no visit process.}

\item{baselags}{Logical scalar for specifying the convention used for lagi and lag_cumavgi terms in the model statements when
the current time index, \eqn{t}, is such that \eqn{t < i}. If this argument is set to \code{FALSE}, the value
of all lagi and lag_cumavgi terms in this context are set to 0 (for non-categorical covariates) or the reference
level (for categorical covariates). If this argument is set to \code{TRUE}, the value of lagi and lag_cumavgi terms
are set to their values at time 0. The default is \code{FALSE}.}
}
\value{
No value is returned. The data table \code{pool} is modified in place.
}
\description{
This internal function applies the history functions to create new columns in an input data table containing new variables that are functions
of the histories of existing variables in the dataset.
}
\keyword{internal}
