% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3methods.R
\name{plot.gformula_continuous_eof}
\alias{plot.gformula_continuous_eof}
\title{Plot method for objects of class "gformula_continuous_eof"}
\usage{
\method{plot}{gformula_continuous_eof}(x, covnames = NULL, ncol = NULL,
  nrow = NULL, common.legend = TRUE, legend = "bottom",
  xlab = NULL, ylab_cov = NULL, ...)
}
\arguments{
\item{x}{Object of class "gformula_continuous_eof".}

\item{covnames}{Vector of character strings specifying the names of the time-varying covariates to be plotted. The ordering of covariates given here is used in the plot grid. Time-varying covariates of type \code{"categorical time"} cannot be included. By default, this argument is set equal to the \code{covnames} argument used in \code{\link{gformula_continuous_eof}}, where covariates of type \code{"categorical time"} are removed.}

\item{ncol}{Number of columns in the plot grid. By default, two columns are used when there is at least two plots.}

\item{nrow}{Number of rows in the plot grid. By default, a maximum of six rows is used and additional plots are included in subsequent pages.}

\item{common.legend}{Logical scalar indicating whether to include a legend. The default is \code{TRUE}.}

\item{legend}{Character string specifying the legend position. Valid values are \code{"top"}, \code{"bottom"}, \code{"left"}, \code{"right"}, and \code{"none"}. The default is \code{"bottom"}.}

\item{xlab}{Character string for the x axes of all plots. By default, this argument is set to the \code{time_name} argument specified in \code{\link{gformula_continuous_eof}}.}

\item{ylab_cov}{Vector of character strings for the y axes of the plots for the covariates. This argument must be the same length as \code{covnames}. The i-th element of this argument corresponds to the plot for the i-th element of \code{covnames}.}

\item{...}{Other arguments, which are passed to \code{\link[ggpubr]{ggarrange}}.}
}
\value{
An object of class "ggarrange". See documentation of \code{\link[ggpubr]{ggarrange}}.
}
\description{
This function generates graphs of the mean simulated vs. observed values at each time point of the
time-varying covariates under the natural course. For categorical covariates,
the observed and simulated counts of the levels of the factors are plotted at each time point.
}
\examples{
## Estimating the effect of treatment strategies on the mean of a continuous
## end of follow-up outcome
\donttest{
library('Hmisc')
id <- 'id'
time_name <- 't0'
covnames <- c('L1', 'L2', 'A')
outcome_name <- 'Y'
covtypes <- c('categorical', 'normal', 'binary')
histories <- c(lagged)
histvars <- list(c('A', 'L1', 'L2'))
covparams <- list(covmodels = c(L1 ~ lag1_A + lag1_L1 + L3 + t0 +
                                  rcspline.eval(lag1_L2, knots = c(-1, 0, 1)),
                                L2 ~ lag1_A + L1 + lag1_L1 + lag1_L2 + L3 + t0,
                                A ~ lag1_A + L1 + L2 + lag1_L1 + lag1_L2 + L3 + t0))
ymodel <- Y ~ A + L1 + L2 + lag1_A + lag1_L1 + lag1_L2 + L3
intvars <- list('A', 'A')
interventions <- list(list(c(static, rep(0, 7))),
                      list(c(static, rep(1, 7))))
int_descript <- c('Never treat', 'Always treat')
nsimul <- 10000

gform_cont_eof <- gformula_continuous_eof(obs_data = continuous_eofdata,
                                          id = id,
                                          time_name = time_name,
                                          covnames = covnames,
                                          outcome_name = outcome_name,
                                          covtypes = covtypes,
                                          covparams = covparams, ymodel = ymodel,
                                          intvars = intvars,
                                          interventions = interventions,
                                          int_descript = int_descript,
                                          histories = histories, histvars = histvars,
                                          basecovs = c("L3"),
                                          nsimul = nsimul, seed = 1234)
plot(gform_cont_eof)
}

}
\seealso{
\code{\link{gformula_continuous_eof}}
}
