% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.rFP.p100.R, R/ggplot_dca.cph.R,
%   R/ggplot_dca.lrm.R
\name{ggplot.rFP.p100}
\alias{ggplot.rFP.p100}
\alias{ggplot.dca.cph}
\alias{ggplot}
\alias{ggplot.dca.lrm}
\title{Plot for decision curve}
\usage{
\method{ggplot}{rFP.p100}(
  data,
  mapping,
  color = TRUE,
  linetype = TRUE,
  lwd = 1.05,
  ...,
  environment = parent.frame()
)

\method{ggplot}{dca.cph}(
  data,
  mapping,
  color = TRUE,
  linetype = TRUE,
  lwd = 1.05,
  ...,
  environment = parent.frame()
)

\method{ggplot}{dca.lrm}(
  data,
  mapping,
  color = TRUE,
  linetype = TRUE,
  lwd = 1.05,
  ...,
  environment = parent.frame()
)
}
\arguments{
\item{data}{results of dca() function}

\item{mapping}{ignore}

\item{color}{logical, whether models will be classified by color}

\item{linetype}{logical, whether models will be classified by line type}

\item{lwd}{line width}

\item{...}{ignore}

\item{environment}{ignore}
}
\value{
a ggplot2 picture
}
\description{
Plot for decision curve

Plot for decision curve

Plot Decision Curve
}
\examples{

library(ggDCA)
library(rms)

######## logistic regression

model1 <- lrm(status~ANLN,LIRI)
d <- dca(model1,model.names = 'ANLN')
ggplot(d)

\donttest{

model2 <- lrm(status~ANLN+CENPA,LIRI)
d <- dca(model2,model.names = 'ANLN+CENPA')
ggplot(d)


model3 <- lrm(status~ANLN+CENPA+GPR182,LIRI)
d <- dca(model3,model.names = 'ANLN+CENPA+GPR182')
ggplot(d)

model4 <- lrm(status~ANLN+CENPA+GPR182+BCO2,LIRI)
d <- dca(model4,model.names = 'ANLN+CENPA+GPR182+BCO2')
ggplot(d)


d <- dca(model1,model2,model3,model4,
         model.names = c('ANLN',
                         'ANLN+CENPA',
                         'ANLN+CENPA+GPR182',
                         'ANLN+CENPA+GPR182+BCO2'))
ggplot(d,
       linetype = FALSE,
       color = c('blue','green','black','red','gray','gray'))


##########  cox regression

# evaluate at median time

model1 <- coxph(Surv(time,status)~ANLN,LIRI)
d <- dca(model1,model.names = 'ANLN')
ggplot(d)

model2 <- coxph(Surv(time,status)~ANLN+CENPA,LIRI)
d <- dca(model2,model.names = 'ANLN+CENPA')
ggplot(d)


model3 <- coxph(Surv(time,status)~ANLN+CENPA+GPR182,LIRI)
d <- dca(model3,model.names = 'ANLN+CENPA+GPR182')
ggplot(d)

model4 <- coxph(Surv(time,status)~ANLN+CENPA+GPR182+BCO2,LIRI)
d <- dca(model4,model.names = 'ANLN+CENPA+GPR182+BCO2')
ggplot(d)


d <- dca(model1,model2,model3,model4,
         model.names = c('ANLN',
                         'ANLN+CENPA',
                         'ANLN+CENPA+GPR182',
                         'ANLN+CENPA+GPR182+BCO2'))
ggplot(d,
       linetype = FALSE,
       color = c('blue','green','black','red','gray','gray'))



# evaluate at different times

qt <- quantile(LIRI$time,c(0.25,0.5,0.75))
qt=round(qt,2)
model1 <- coxph(Surv(time,status)~ANLN,LIRI)
d <- dca(model1,
         model.names = 'ANLN',
         times = qt)
ggplot(d)

model2 <- coxph(Surv(time,status)~ANLN+CENPA,LIRI)
d <- dca(model2,
         model.names = 'ANLN+CENPA',
         times = qt)
ggplot(d)


model3 <- coxph(Surv(time,status)~ANLN+CENPA+GPR182,LIRI)
d <- dca(model3,
         model.names = 'ANLN+CENPA+GPR182',
         times = qt)
ggplot(d)

model4 <- coxph(Surv(time,status)~ANLN+CENPA+GPR182+BCO2,LIRI)
d <- dca(model4,
         model.names = 'ANLN+CENPA+GPR182+BCO2',
         times = qt)
ggplot(d)


d <- dca(model1,model2,model3,model4,
         model.names = c('ANLN',
                         'ANLN+CENPA',
                         'ANLN+CENPA+GPR182',
                         'ANLN+CENPA+GPR182+BCO2'),
         times = qt)
ggplot(d)
}
}
