% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-density.R
\name{pmx_dens}
\alias{pmx_dens}
\title{Creates a density plot object}
\usage{
pmx_dens(
  x,
  labels,
  dname = NULL,
  xlim = 3,
  var_line = NULL,
  snd_line = NULL,
  vline = NULL,
  is.legend = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{character} variable name to sample}

\item{labels}{list of texts/titles used within the plot}

\item{dname}{name of dataset to be used}

\item{xlim}{\code{numeric} x axis limits}

\item{var_line}{\code{list} variable density graphics parameters}

\item{snd_line}{\code{list} normal density graphics parameters}

\item{vline}{\code{list} vertical line graphics parameters}

\item{is.legend}{\code{logical} whether to add a legend (defaults TRUE)}

\item{...}{others graphics arguments passed to \code{\link{pmx_gpar}} internal object.}
}
\description{
Creates a density plot object
}
\details{
\strong{labels} is a list that contains:
\itemize{
\item {\strong{title:}} {plot title default  "IWRES density plot"}
\item {\strong{x:}} {x axis label default to "Etas"}
\item {\strong{y:}} {y axis label default to empty}
}

\strong{var_line} is a list that contains:
\itemize{
\item {\strong{linetype:}} {default to 1}
\item {\strong{color:}} {default to black}
\item {\strong{linewidth:}} {default to 1}
}

\strong{snd_line} is a list that contains:
\itemize{
\item {\strong{linetype:}} {default to 2}
\item {\strong{color:}} {default to black}
\item {\strong{linewidth:}} {default to 1}
}

\strong{vline} is a list that contains:
\itemize{
\item {\strong{linetype:}} {default to 3}
\item {\strong{color:}} {default to black}
\item {\strong{linewidth:}} {default to 1}
}
}
