% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_QC_FUNs.R
\name{uBar_UCL}
\alias{uBar_UCL}
\title{Upper Control Limit: Count Data (u-chart)}
\usage{
uBar_UCL(y, n, na.rm = FALSE, ...)
}
\arguments{
\item{y}{Vector of counts per unit opportunity (rate). Observations
may have a different area of opportunity, n.}

\item{n}{A vector representing the area of opportunity.}

\item{na.rm}{a logical value indicating whether NA values should be stripped before the computation proceeds.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A vector; point-wise 3-sigma upper control limit (UCL)
}
\description{
Calculates point-wise upper control limit (UCL)
for count data acquired over a variable area of
opportunity.
}
\examples{
set.seed(5555)
counts <- rpois(100, 25)
n <- rpois(100, 15)
uBar_UCL(y = counts / n, n = n)

}
