% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.gg_minimal_vimp.R
\name{plot.gg_minimal_vimp}
\alias{plot.gg_minimal_vimp}
\title{Plot a \code{\link{gg_minimal_vimp}} object for comparing the Minimal
Depth and VIMP variable rankings.}
\usage{
\method{plot}{gg_minimal_vimp}(x, nvar, lbls, ...)
}
\arguments{
\item{x}{\code{\link{gg_minimal_depth}} object created from a
\code{\link[randomForestSRC]{var.select}}
object}

\item{nvar}{should the figure be restricted to a subset of the points.}

\item{lbls}{a vector of alternative variable names.}

\item{...}{optional arguments (not used)}
}
\value{
\code{ggplot} object
}
\description{
Plot a \code{\link{gg_minimal_vimp}} object for comparing the Minimal
Depth and VIMP variable rankings.
}
\examples{
\dontrun{
## Examples from RFSRC package...
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
## -------- iris data
## You can build a randomForest
# rfsrc_iris <- rfsrc(Species ~ ., data = iris)
# varsel_iris <- var.select(rfsrc_iris)
# ... or load a cached randomForestSRC object
data(varsel_iris, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
gg_dta<- gg_minimal_vimp(varsel_iris)

# Plot the gg_minimal_depth object
plot(gg_dta)

## ------------------------------------------------------------
## Regression example
## ------------------------------------------------------------
## -------- air quality data
rfsrc_airq <- rfsrc(Ozone ~ ., data = airquality, na.action = "na.impute")
varsel_airq <- var.select(rfsrc_airq)

# Get a data.frame containing error rates
gg_dta<- gg_minimal_vimp(varsel_airq)

# Plot the gg_minimal_vimp object
plot(gg_dta)

## -------- Boston data
data(varsel_boston, package="ggRandomForests")

# Get a data.frame containing error rates
gg_dta<- gg_minimal_vimp(varsel_boston)

# Plot the gg_minimal_vimp object
plot(gg_dta)

## -------- mtcars data
data(varsel_mtcars, package="ggRandomForests")

# Get a data.frame containing error rates
gg_dta<- gg_minimal_vimp(varsel_mtcars)

# Plot the gg_minimal_vimp object
plot(gg_dta)

## ------------------------------------------------------------
## Survival example
## ------------------------------------------------------------
## -------- veteran data
## randomized trial of two treatment regimens for lung cancer
# data(veteran, package = "randomForestSRC")
# rfsrc_veteran <- rfsrc(Surv(time, status) ~ ., data = veteran, ntree = 100)
# varsel_veteran <- var.select(rfsrc_veteran)
# Load a cached randomForestSRC object
data(varsel_veteran, package="ggRandomForests")

gg_dta <- gg_minimal_vimp(varsel_veteran)
plot(gg_dta)

## -------- pbc data
data(varsel_pbc, package="ggRandomForests")

gg_dta <- gg_minimal_vimp(varsel_pbc)
plot(gg_dta)
}

}
\seealso{
\code{\link{gg_minimal_vimp}}
\code{\link[randomForestSRC]{var.select}}
}
