% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition-filter.R
\name{transition_filter}
\alias{transition_filter}
\title{Transition between different filters}
\usage{
transition_filter(transition_length = 1, filter_length = 1, ...,
  wrap = TRUE, keep = FALSE)
}
\arguments{
\item{transition_length}{The relative length of the transition. Will be
recycled to match the number of states in the data}

\item{filter_length}{The relative length of the pause at the states. Will be
recycled to match the number of states in the data}

\item{...}{A number of expressions to be evaluated in the context of the layer
data, returning a logical vector. If the expressions are named, the name will
be available as a frame variable.}

\item{wrap}{Should the animation \emph{wrap-around}? If \code{TRUE} the last filter will
be transitioned into the first.}

\item{keep}{Should rows that evaluates to \code{FALSE} be kept in the data as it
looks after exit has been applied}
}
\description{
This transition allows you to transition between a range of filtering
conditions. The conditions are expressed as logical statements and rows in
the data will be retained if the statement evaluates to \code{TRUE}. It is
possible to keep filtered data on display by setting \code{keep = TRUE} which will
let data be retained as the result of the exit function. Note that if data is
kept the enter function will have no effect.
}
\section{Label variables}{

\code{transition_filter} makes the following variables available for string
literal interpretation, in addition to the general ones provided by
\code{\link[=animate]{animate()}}:
\itemize{
\item \strong{transitioning} is a boolean indicating whether the frame is part of the
transitioning phase
\item \strong{previous_filter} The name of the last filter the animation was at
\item \strong{closest_filter} The name of the filter closest to this frame
\item \strong{next_filter} The name of the next filter the animation will be part of
\item \strong{previous_expression} The expression of the last filter the animation was at
\item \strong{closest_expression} The expression of the filter closest to this frame
\item \strong{next_expression} The expression of the next filter the animation will be part of
}
}

\section{Object permanence}{

\code{transition_filter} does not link rows across data to the same graphic
element, so elements will be defined uniquely by each row. If \code{keep = TRUE}
the rows not matching the conditions of a filter is not removed from the plot
after the exit animation, and a possible subsequent enter will begin from
the state they were left in, rather than enter anew from the state defined by
the enter function.
}

\section{Computed Variables}{

It is possible to use variables calculated by the statistic to define the
transition. Simply inclose the variable in \code{stat()} in the same way as when
using computed variables in aesthetics.
}

\examples{
anim <- ggplot(iris, aes(Petal.Width, Petal.Length, colour = Species)) +
  geom_point() +
  transition_filter(
    transition_length = 2,
    filter_length = 1,
    Setosa = Species == 'setosa',
    Long = Petal.Length > 4,
    Wide = Petal.Width > 2
  ) +
  ggtitle(
    'Filter: {closest_filter}',
    subtitle = '{closest_expression}'
  ) +
  enter_fade() +
  exit_fly(y_loc = 0)

# Setting `keep = TRUE` allows you to keep the culled data on display. Only
# exit functions will be used in that case (as elements enters from the
# result of the exit function)
anim2 <- ggplot(iris, aes(Petal.Width, Petal.Length, colour = Species)) +
  geom_point() +
  transition_filter(
    transition_length = 2,
    filter_length = 1,
    Setosa = Species == 'setosa',
    Long = Petal.Length > 4,
    Wide = Petal.Width > 2,
    keep = TRUE
  ) +
  ggtitle(
    'Filter: {closest_filter}',
    subtitle = '{closest_expression}'
  ) +
  exit_recolour(colour = 'grey') +
  exit_shrink(size = 0.5)

}
\seealso{
Other transitions: \code{\link{transition_components}},
  \code{\link{transition_events}},
  \code{\link{transition_layers}},
  \code{\link{transition_manual}},
  \code{\link{transition_null}},
  \code{\link{transition_reveal}},
  \code{\link{transition_states}},
  \code{\link{transition_time}}
}
\concept{transitions}
