% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggb.R
\name{ggb}
\alias{ggb}
\title{Generic R6 base class that is used to support + semantics}
\description{
Generic R6 base class that is used to support + semantics

Generic R6 base class that is used to support + semantics
}
\details{
this object becomes a simple storage class that contains all relevant objects
(e.g., ggbrain_images) required to generate a brain plot
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ggb_images}}{ggbrain_images object for this plot}

\item{\code{ggb_image_labels}}{a named list of data.frames that label corresponding images}

\item{\code{ggb_slices}}{list slices to extract for this plot}

\item{\code{ggb_contrasts}}{a character vector of contrasts to be computed as part of this plot}

\item{\code{ggb_layers}}{a list of ggbrain_layer objects containing the bottom-to-top layers to be plotted}

\item{\code{ggb_plot}}{a ggbrain_plot object containing the specification of the plot}

\item{\code{ggb_annotations}}{a list of annotation objects}

\item{\code{ggb_region_labels}}{a list of ggbrain_label objects to be added as text to label regions}

\item{\code{action}}{what should this ggb object contribute to another when added with it?}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ggb-new}{\code{ggb$new()}}
\item \href{#method-ggb-add_layers}{\code{ggb$add_layers()}}
\item \href{#method-ggb-add_slices}{\code{ggb$add_slices()}}
\item \href{#method-ggb-add_contrasts}{\code{ggb$add_contrasts()}}
\item \href{#method-ggb-add_annotations}{\code{ggb$add_annotations()}}
\item \href{#method-ggb-add_image_labels}{\code{ggb$add_image_labels()}}
\item \href{#method-ggb-add_region_labels}{\code{ggb$add_region_labels()}}
\item \href{#method-ggb-render}{\code{ggb$render()}}
\item \href{#method-ggb-plot}{\code{ggb$plot()}}
\item \href{#method-ggb-clone}{\code{ggb$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggb-new"></a>}}
\if{latex}{\out{\hypertarget{method-ggb-new}{}}}
\subsection{Method \code{new()}}{
create a new ggb object. Note that inputs are always cloned to avoid
unintended modify-in-place behaviors of R6 classes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggb$new(
  images = NULL,
  slices = NULL,
  contrasts = NULL,
  layers = NULL,
  labels = NULL,
  annotations = NULL,
  region_labels = NULL,
  title = NULL,
  bg_color = NULL,
  text_color = NULL,
  base_size = NULL,
  action = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{images}}{a ggbrain_images object containing relevant images}

\item{\code{slices}}{a character vector of slices to extract}

\item{\code{contrasts}}{a character vector of contrasts to define and compute}

\item{\code{layers}}{a list of ggbrain_layer objects}

\item{\code{labels}}{a list of data.frames with labels that align with one or more images}

\item{\code{annotations}}{a list of data.frames with annotations that will be added to specific slices}

\item{\code{region_labels}}{a list of ggbrain_label objects with text-based labels to be drawn on the plot}

\item{\code{title}}{overall title of the plot}

\item{\code{bg_color}}{the background color of the overall plot}

\item{\code{text_color}}{the text color of the overall plot}

\item{\code{base_size}}{the base size of text on the plot}

\item{\code{action}}{the action to be taken when adding this object to an existing ggb}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggb-add_layers"></a>}}
\if{latex}{\out{\hypertarget{method-ggb-add_layers}{}}}
\subsection{Method \code{add_layers()}}{
add layers from another ggb object to this one
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggb$add_layers(ilist)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ilist}}{a list of ggbrain_layer objects. If a ggb object is passed, we
will get this list from obj$ggb_layers}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggb-add_slices"></a>}}
\if{latex}{\out{\hypertarget{method-ggb-add_slices}{}}}
\subsection{Method \code{add_slices()}}{
add slices to the existing vector of slices
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggb$add_slices(slices = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{slices}}{a character vector of slices to be appended to the existing slices}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggb-add_contrasts"></a>}}
\if{latex}{\out{\hypertarget{method-ggb-add_contrasts}{}}}
\subsection{Method \code{add_contrasts()}}{
add contrast definitions to the plot object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggb$add_contrasts(contrasts)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{contrasts}}{a character vector of contrasts to compute as part of the plot generation}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggb-add_annotations"></a>}}
\if{latex}{\out{\hypertarget{method-ggb-add_annotations}{}}}
\subsection{Method \code{add_annotations()}}{
add annotations to panels
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggb$add_annotations(annotations = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{annotations}}{a list or data.frame containing the annotations to add to each panel. Minimally,
the list or data.frame must contain \code{position} and \code{label} columns that define the position
and text to be added. Other arguments that pass through to ggplot2::annotate() can be provided as columns/elements
in \code{annotations} and these will be passed through to annotate}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggb-add_image_labels"></a>}}
\if{latex}{\out{\hypertarget{method-ggb-add_image_labels}{}}}
\subsection{Method \code{add_image_labels()}}{
add labels to a given image
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggb$add_image_labels(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{a named list of arguments where each is a data.frame with labels denoting corresponding images}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggb-add_region_labels"></a>}}
\if{latex}{\out{\hypertarget{method-ggb-add_region_labels}{}}}
\subsection{Method \code{add_region_labels()}}{
add a list of ggbrain_label objects to the overall ggb for compiling a plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggb$add_region_labels(labels = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{labels}}{a list of data.frames with region labels that should be plotted on each slice. This is generated
internally by ggbrain_images$get_slices() in the $slice_labels field.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggb-render"></a>}}
\if{latex}{\out{\hypertarget{method-ggb-render}{}}}
\subsection{Method \code{render()}}{
this method converts the ggb object into a compiled ggplot2 object that can then be passed to other
functions from cowplot, ggplot2, and patchwork. Once the object is rendered, it no longer retains the underlying ggb
fields that contain the elemental data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggb$render(guides = "collect")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{guides}}{Passes through to patchwork::plot_layout to control how legends are combined across plots. The default
is "collect", which collects legends within a given nesting level (removes duplicates).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggb-plot"></a>}}
\if{latex}{\out{\hypertarget{method-ggb-plot}{}}}
\subsection{Method \code{plot()}}{
plot this ggb object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggb$plot(guides = "collect")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{guides}}{Passes through to patchwork::plot_layout to control how legends are combined across plots. The default
is "collect", which collects legends within a given nesting level (removes duplicates).}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
requires that required elements are in place already.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggb-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ggb-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggb$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
