% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_posterior.R, R/ggdistribute-package.R,
%   R/stat_posterior_density.R
\name{geom_posterior}
\alias{geom_posterior}
\alias{GeomPosterior}
\alias{stat_density_ci}
\title{Geom for plotting posterior distributions}
\usage{
geom_posterior(mapping = NULL, data = NULL, stat = "DensityCI",
  position = "spread", ..., draw_ci = TRUE, draw_sd = TRUE,
  midline = "#767698", brighten = TRUE, mirror = FALSE,
  interp_thresh = NULL, na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)

stat_density_ci(mapping = NULL, data = NULL, geom = "Posterior",
  position = "spread", ..., center_stat = "median", ci_width = 0.9,
  interval_type = "ci", bw = "nrd0", adjust = 1,
  kernel = "gaussian", cut = 1, n = 1024, trim = 0.01,
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data.}

\item{stat}{Used to override the default connection between \code{geom_posterior}
and \code{stat_density_ci}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{draw_ci}{\emph{geom}. Toggles drawing of the confidence interval lines and
segments.}

\item{draw_sd}{\emph{geom}. Toggles drawing of the standard deviation interval
lines and segments.}

\item{midline}{\emph{geom}. Color of the vertical, center line. Set to \code{NA}
to omit the line.}

\item{brighten}{\emph{geom}. Numeric adjustments to the fill color. A value above
1 increases brightness, below decreases. Should be of length 1 or 5,
otherwise values are recycled}

\item{mirror}{\emph{geom}. Show standard densities (\code{mirror=FALSE}) or horizontal
violin densities (\code{mirror=TRUE}).}

\item{interp_thresh}{\emph{geom}. If the number of samples used to estimate the
density is low, this will result in gaps between segments. This argument
decides to interpolate points based on gap proportion for a segment.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{geom}{Use to override the default connection between \code{geom_posterior}
and \code{stat_density_ci}}

\item{center_stat}{\emph{stat}. character string of method to compute the
distribution's central tendency, such as \code{"median"}, \code{"mean"}, or \code{"mode"}.}

\item{ci_width}{\emph{stat}. Width of the distribution's confidence/highest
density interval, e.g., 0.95}

\item{interval_type}{\emph{stat}. method of computing the interval, either \code{"hdi"}
or \code{"ci"}}

\item{bw}{The smoothing bandwidth to be used. If numeric, the standard
deviation of the smoothing kernel. If character, a rule to choose the
bandwidth, as listed in \link[stats:bandwidth]{stats::bandwidth}. If the bandwidth character
starts wit a \code{"."} (e.g., \code{".nrd0"}), then the average bandwidth will be
calculated among all groups in a panel and used for each density estimate.}

\item{adjust}{A multiplicate bandwidth adjustment. This makes it possible
to adjust the bandwidth while still using the a bandwidth estimator.
For example, \code{adjust = 1/2} means use half of the default bandwidth.}

\item{kernel}{Kernel. See list of available kernels in \code{\link[=density]{density()}}.}

\item{cut}{The values to use for the start and end of the density estimation
are \code{cut} bandwidths (e.g., \code{0.5*bw}) \emph{beyond} the extremes of the data.
This allows the estimated density to drop to approximately zero at the
extremes.}

\item{n}{number of equally spaced points at which the density is to be
estimated, should be a power of two, see \code{\link[=density]{density()}} for
details}

\item{trim}{If a value between 0 and 1 is given, trim the tails of \code{x} by
some proportion according to \code{trim}. If \code{NULL} or \code{NA}, don't trim the
tails. See \code{\link[=trim_ends]{trim_ends()}}.}
}
\description{
This geom may be used to plot the density of any type of numeric variable but
the displayed intervals may not be informative if the distribution deviates
too much from a unimodal, symmetric distribution.
}
\section{Functions}{
\itemize{
\item \code{geom_posterior}: geom_posterior Posterior Geom

\item \code{stat_density_ci}: stat_density_ci Computes a distribution density and
confidence intervals for each group
}}

\section{Aesthetics}{


\code{geom_posterior} understands the following aesthetics (required aesthetics
are in bold):
\itemize{
\item \strong{x}
\item \strong{y}
\item xmin
\item xmax
\item alpha - colour
\item fill
\item group
\item linetype
\item size
\item weight
}
}

\section{Computed Variables}{


\emph{stat_density_ci}:
\itemize{
\item density: density estimate from \link[stats:density]{stats::density}
\item scaled: Normalized density values: \code{density / max(density)}
\item count: Number of samples at density level: \code{(density / sum(density)) * n}
\item xmin: minimum value of \code{x} from the data
\item cil: cil cutoff value based on \code{ci_width}
\item sdl: central value minus 1 sd of \code{x}
\item mid: value of central tendency
\item sdu: central value plus 1 sd of \code{x}
\item ciu: ciu cutoff value based on \code{ci_width}
\item xmax: maximum value of \code{x} from the data
}

\emph{position_spread}
\itemize{
\item ymin: minimum value of \code{y} for each group in a panel.
\item ymax: maximum value of \code{y} for each group in a panel.
}
}

\examples{
\donttest{
library(ggplot2)

x <- data_normal_sample(mu = c(-1, 0, 1), n = 500)

p <- ggplot(x, aes(x = value))

p + geom_posterior()

p + geom_posterior(aes(y = Condition))

p + geom_posterior(aes(y = GroupScore, fill = Condition))

p + geom_posterior(aes(y = GroupScore, fill = Group),
brighten = c(1.3, 0, -1.3),
position = position_spread(
height=0.5,
padding = 0))

}
}
