% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_wrap_paginate.R
\name{n_pages}
\alias{n_pages}
\title{Determine the number of pages in a paginated facet plot}
\usage{
n_pages(plot)
}
\arguments{
\item{plot}{A ggplot object using either facet_wrap_paginate or
facet_grid_paginate}
}
\value{
If the plot uses  using either facet_wrap_paginate or
facet_grid_paginate it returns the total number of pages. Otherwise it
returns NULL
}
\description{
This is a simple helper that returns the number of pages it takes to plot all
panels when using \code{\link{facet_wrap_paginate}} and
\code{\link{facet_grid_paginate}}. It partially builds the plot so depending
on the complexity of your plot it might take some time to calculate...
}
\examples{
p <- ggplot(diamonds) +
    geom_point(aes(carat, price), alpha = 0.1) +
    facet_wrap_paginate(~cut:clarity, ncol = 3, nrow = 3, page = 1)
n_pages(p)

}
