% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_abline}
\alias{gf_abline}
\alias{gf_hline}
\alias{gf_vline}
\alias{gf_coefline}
\title{Reference lines -- horizontal, vertical, and diagonal.}
\usage{
gf_abline(object = NULL, gformula = NULL, data = NA, geom = "abline",
  stat = "identity", position = "identity", show.legend = NA,
  show.help = NULL, inherit = FALSE, ...)

gf_hline(object = NULL, gformula = NULL, data = NA, geom = "hline",
  stat = "identity", position = "identity", show.legend = NA,
  show.help = NULL, inherit = FALSE, ...)

gf_vline(object = NULL, gformula = NULL, data = NA, geom = "vline",
  stat = "identity", position = "identity", show.legend = NA,
  show.help = NULL, inherit = FALSE, ...)

gf_coefline(object = NULL, coef = NULL, model = NULL, ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{Must be \code{NULL}.}

\item{data}{A data frame with the variables to be plotted.}

\item{geom}{A character string naming the geom used to make the layer.}

\item{stat}{A character string naming the stat used to make the layer.}

\item{position}{Either a character string naming the position function used
for the layer or a position object returned from a call to a position function.}

\item{show.legend}{A logical indicating whether this layer should be included in
the legends.  \code{NA}, the default, includes layer in the legends if any
of the attributes of the layer are mapped.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.
Available attributes include
\code{slope}, \code{intercept}}

\item{coef}{A numeric vector of length at least 2, treated as intercept and slope.
Additional components, if any, are ignored (with a warning).}

\item{model}{An object with a method for \code{coef()} that returns a
numeric vector, the first two elements of which are intercept and slope.
This is equivalent to \code{coef = coef(model)}.}
}
\value{
a gg object
}
\description{
These functions create layers that display lines described i various ways.  Unlike most
of the plotting functions in \code{ggformula}, these functions do not take a formula
as input for describing positional attributes of the plot.
}
\examples{
mtcars2 <- df_stats( wt ~ cyl, data = mtcars)
gf_point(wt ~ hp, size = ~wt, color = ~cyl, data = mtcars) \%>\%
  gf_abline(slope = 0, intercept = ~median, color = ~cyl, data = mtcars2)
gf_point(wt ~ hp, size = ~wt, color = ~cyl, data = mtcars) \%>\%
  gf_hline(slope = 0, yintercept = ~median, color = ~cyl, data = mtcars2)

gf_point(mpg ~ hp, color = ~cyl, size = ~wt, data = mtcars) \%>\%
  gf_abline(color="red", slope = -0.10, intercept = 35)
gf_point(mpg ~ hp, color = ~cyl, size = ~wt, data = mtcars) \%>\%
  gf_abline(color = "red", slope = ~slope, intercept = ~intercept,
  data = data.frame(slope = -0.10, intercept = 33:35))
gf_point(mpg ~ hp, color = ~cyl, size = ~wt, data = mtcars) \%>\%
  gf_abline(intercept = ~ c(10, 20, 30), slope = ~c(1, 0, -1)/100,
    color = c("red", "green", "blue"))

# We can set the color of the guidelines while mapping color in other
# layers
gf_point(mpg ~ hp, color = ~cyl, size = ~wt, data = mtcars) \%>\%
  gf_hline(color = "navy", yintercept = ~c(20, 25)) \%>\%
  gf_vline(color = "brown", xintercept = ~c(200, 300))

# If we want to map the color of the guidelines, it must work with the
# scale of the other colors in the plot.
gf_point(mpg ~ hp, size = ~wt, data = mtcars, alpha = 0.3) \%>\%
  gf_hline(color = ~"horizontal", yintercept = ~c(20, 25)) \%>\%
  gf_vline(color = ~"vertical", xintercept = ~c(100, 200, 300), data = NA)
gf_point(mpg ~ hp, size = ~wt, color = ~ factor(cyl), data = mtcars, alpha = 0.3) \%>\%
  gf_hline(color = "orange", yintercept = 20, data = NA) \%>\%
  gf_vline(color = ~c("4", "6", "8"), xintercept = c(80, 120, 250), data = NA) \%>\%
# reversing the layers requires using inherit = FALSE
gf_hline(color = "orange", yintercept = 20, data = NA) \%>\%
  gf_vline(color = ~c("4", "6", "8"), xintercept = c(80, 120, 250), data = NA) \%>\%
  gf_point(mpg ~ hp, size = ~wt, color = ~ factor(cyl), data = mtcars, alpha = 0.3,
    inherit = FALSE)


}
\seealso{
\code{\link[=geom_abline]{geom_abline()}},
\code{\link[=geom_vline]{geom_vline()}},
\code{\link[=geom_hline]{geom_hline()}}
}
