% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_count_interactive.R
\name{geom_count_interactive}
\alias{geom_count_interactive}
\title{Create interactive point counts}
\usage{
geom_count_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \link{interactive_parameters}.}
}
\description{
The geometry is based on \code{\link[ggplot2:geom_bin_2d]{ggplot2::geom_bin2d()}}.
See the documentation for those functions for more details.
}
\section{Details for interactive geom functions}{

The interactive parameters can be supplied with two ways:
\itemize{
\item As aesthetics with the mapping argument (via \code{\link[ggplot2:aes]{ggplot2::aes()}}).
In this way they can be mapped to data columns and apply to a set of geometries.

\item As plain arguments into the geom_*_interactive function.
In this way they can be set to a scalar value.
}
}

\examples{
# add interactive point counts to a ggplot -------
library(ggplot2)
library(ggiraph)

p <- ggplot(mpg, aes(cty, hwy)) +
  geom_count_interactive(aes(tooltip = after_stat(n)))
x <- girafe(ggobj = p)
if (interactive()) {
  print(x)
}

p2 <- ggplot(diamonds, aes(x = cut, y = clarity)) +
  geom_count_interactive(aes(
    size = after_stat(prop),
    tooltip = after_stat(round(prop, 3)),
    group = 1
  )) +
  scale_size_area(max_size = 10)
x <- girafe(ggobj = p2)
if (interactive()) {
  print(x)
}
}
\seealso{
\code{\link[=girafe]{girafe()}}
}
