% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggEffect.R
\name{ggEffect}
\alias{ggEffect}
\alias{ggEffect.default}
\alias{ggEffect.formula}
\alias{ggEffect.lm}
\title{Visualize the effect of interaction between two continuous independent variables on a response variable}
\usage{
ggEffect(x, ...)

\method{ggEffect}{default}(x, mapping, ...)

\method{ggEffect}{formula}(x, data, ...)

\method{ggEffect}{lm}(x, no = 1, probs = c(0.1, 0.5, 0.9), point = TRUE,
  xvalue = NULL, digits = 2, use.rownames = FALSE, interactive = FALSE,
  ...)
}
\arguments{
\item{x}{Object to ggEffect}

\item{...}{additional arguments passed to the generic function}

\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{data}{A data.frame}

\item{no}{an integer}

\item{probs}{A vector of probability weights for obtaining the elements of the vector being sampled.Default value is c(0.10,0.5,0.90)}

\item{point}{A logical value. If TRUE, draw points}

\item{xvalue}{A numeric vector}

\item{digits}{An integer indicating the number of decimal places}

\item{use.rownames}{If TRUE, use rownames in label}

\item{interactive}{A logical value. If TRUE, an interactive plot will be returned}
}
\value{
An interactive plot showing interaction
}
\description{
Visualize the effect of interaction between two continuous independent variables on a response variable
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Visualize the effect of interaction between two continuous independent variables on a response variable

\item \code{formula}: Visualize the effect of interaction between two continuous independent variables on a response variable

\item \code{lm}: Visualize the effect of interaction between two continuous independent variables on a response variable
}}
\examples{
require(ggplot2)
require(ggiraph)
ggEffect(mtcars,aes(x=wt,y=mpg,color=hp),use.rownames=TRUE,interactive=TRUE)
require(moonBook)
ggEffect(NTAV~age*smoking,data=radial,interactive=TRUE)
fit=lm(age~sex*smoking,data=acs)
ggEffect(fit,interactive=TRUE)
}

