% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoms-gradient.R
\docType{data}
\name{geom_ridgeline_gradient}
\alias{geom_ridgeline_gradient}
\alias{GeomRidgelineGradient}
\alias{geom_joy_gradient}
\alias{GeomJoyGradient}
\title{Plot ridgelines and joyplots with fill gradients along the x axis}
\usage{
geom_ridgeline_gradient(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", na.rm = FALSE, gradient_lwd = 0.5,
  show.legend = NA, inherit.aes = TRUE, ...)

geom_joy_gradient(mapping = NULL, data = NULL, stat = "joy",
  panel_scaling = TRUE, na.rm = TRUE, gradient_lwd = 0.5,
  show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{gradient_lwd}{A parameter to needed to remove rendering artifacts inside the
rendered gradients. Should ideally be 0, but often needs to be around 0.5 or higher.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them.}

\item{...}{other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{panel_scaling}{Argument only to \code{geom_joy_gradient}. If \code{TRUE}, the default, relative scaling is calculated separately
for each panel. If \code{FALSE}, relative scaling is calculated globally.}
}
\description{
The geoms \code{geom_ridgeline_gradient} and \code{geom_joy_gradient} work just like \code{\link{geom_ridgeline}} and \code{\link{geom_joy}} except
that the \code{fill} aesthetic can vary along the x axis. Because filling with color gradients is fraught with issues,
these geoms should be considered experimental. Don't use them unless you really need to. Note that due to limitations
in R's graphics system, transparency (\code{alpha}) has to be disabled for gradient fills.
}
\examples{
# Example for `geom_ridgeline_gradient()`
library(viridis)
d <- data.frame(x = rep(1:5, 3) + c(rep(0, 5), rep(0.3, 5), rep(0.6, 5)),
                y = c(rep(0, 5), rep(1, 5), rep(3, 5)),
                height = c(0, 1, 3, 4, 0, 1, 2, 3, 5, 4, 0, 5, 4, 4, 1))
ggplot(d, aes(x, y, height = height, group = y, fill = factor(x+y))) +
  geom_ridgeline_gradient() +
  scale_fill_viridis(discrete = TRUE, direction = -1) +
  theme(legend.position = 'none')

# Example for `geom_joy_gradient()`
ggplot(lincoln_weather, aes(x = `Mean Temperature [F]`, y = `Month`, fill = ..x..)) +
  geom_joy_gradient(scale = 3, rel_min_height = 0.01) +
  scale_x_continuous(expand = c(0.01, 0)) +
  scale_y_discrete(expand = c(0.01, 0)) +
  scale_fill_viridis(name = "Temp. [F]", option = "C") +
  labs(title = 'Temperatures in Lincoln NE in 2016') +
  theme_joy(font_size = 13, grid = TRUE) + theme(axis.title.y = element_blank())
}
\keyword{datasets}
