% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb2bbox.R
\name{bb2bbox}
\alias{bb2bbox}
\title{Convert a bb specification to a bbox specification}
\usage{
bb2bbox(bb)
}
\arguments{
\item{bb}{a bounding box in bb format (see examples)}
}
\value{
a bounding box in bbox format (see examples)
}
\description{
In ggmap, all maps (class ggmap) have the bb attribute, a data
frame bounding box specification in terms of the bottom left and
top right points of the spatial extent. This function converts
this specification to a named double vector (with names left,
bottom, right, top) specification that is used in some querying
functions (e.g. get_stamenmap).
}
\examples{

\dontrun{# cut down on R CMD check time

# grab a center/zoom map and compute its bounding box
gc <- geocode("white house, washington dc")
map <- get_map(gc)
(bb <- attr(map, "bb"))
(bbox <- bb2bbox(bb))

# use the bounding box to get a stamen map
stamMap <- get_stamenmap(bbox)

ggmap(map) +
  geom_point(
    aes(x = lon, y = lat),
    data = gc, colour = "red", size = 3
  )

ggmap(stamMap) +
  geom_point(
    aes(x = lon, y = lat),
    data = gc, colour = "red", size = 3
  )


}


}
\author{
David Kahle \email{david@kahle.io}
}
