% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MullerPlot.R
\name{get_Muller_df}
\alias{get_Muller_df}
\title{Create a data frame from which to create a Muller plot}
\usage{
get_Muller_df(edges, pop_df, add_zeroes = FALSE, threshold = 0,
  smooth_start_points = FALSE)
}
\arguments{
\item{edges}{Dataframe comprising an adjacency matrix, or tree of class "phylo"}

\item{pop_df}{Dataframe with column names "Generation", "Identity" and "Population"}

\item{add_zeroes}{Logical whether to include rows with Population = 0}

\item{threshold}{Numeric threshold; genotypes that never become more abundant than this threshold are omitted}

\item{smooth_start_points}{Logical whether to replace subpopulations of size zero (at generations > 0) with a very small number for smoother plotting of start points}
}
\value{
A dataframe that can be used as input in Muller_plot and Muller_pop_plot.
}
\description{
Create a data frame from which to create a Muller plot
}
\examples{
# by default, all genotypes are included, 
# but one can choose to omit genotypes with max frequency < threshold:
Muller_df <- get_Muller_df(example_edges, example_pop_df, threshold = 0.005)

# one can also choose to include rows with Population = 0:
Muller_df <- get_Muller_df(example_edges, example_pop_df, add_zeroes = TRUE, threshold = 0.005)

# the genotype names can be arbitrary character strings instead of numbers:
example_edges_char <- example_edges
example_edges_char$Identity <- paste0("foo", example_edges_char$Identity, "bar")
example_edges_char$Parent <- paste0("foo", example_edges_char$Parent, "bar")
example_pop_df_char <- example_pop_df
example_pop_df_char$Identity <- paste0("foo", example_pop_df_char$Identity, "bar")
Muller_df <- get_Muller_df(example_edges_char, example_pop_df_char, threshold = 0.005)

# the genotype names can also be factors (which is the default for characters in imported data):
example_edges_char$Identity <- as.factor(example_edges_char$Identity)
example_edges_char$Parent <- as.factor(example_edges_char$Parent)
example_pop_df_char$Identity <- as.factor(example_pop_df_char$Identity)
Muller_df <- get_Muller_df(example_edges_char, example_pop_df_char, threshold = 0.005)

}
\seealso{
\code{\link{Muller_plot}} \code{\link{Muller_pop_plot}}
}
\author{
Rob Noble, \email{robjohnnoble@gmail.com}
}
