% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MullerPlot.R
\name{move_down}
\alias{move_down}
\title{Move to daughter in adjacency matrix}
\usage{
move_down(edges, parent)
}
\arguments{
\item{edges}{Dataframe comprising an adjacency matrix, with column names "Parent" and "Identity"}

\item{parent}{number or character string specifying whose daughter is to be found}
}
\value{
The daughter's Identity.
}
\description{
Returns the first Identity value in the sorted set of daughters. 
When parent has no daughters, returns the input Identity.
}
\examples{
edges1 <- data.frame(Parent = c(1,1,1,3,3), Identity = 2:6)
move_down(edges1, 3)

}
\seealso{
\code{\link{move_up}} \code{\link{move_right}}
}
\author{
Rob Noble, \email{robjohnnoble@gmail.com}
}
