% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processExtras.R
\name{processExtras}
\alias{processExtras}
\title{Process duplicate appearances of individuals in a pedigree layout}
\usage{
processExtras(ped, config = list())
}
\arguments{
\item{ped}{A data.frame containing pedigree layout info with columns including:
`personID`, `x_pos`, `y_pos`, `dadID`, `momID`, and a logical column `extra`.}

\item{config}{A list of configuration options. Currently unused but passed through to internal helpers.}
}
\value{
A modified `ped` data.frame with updated coordinates and removed duplicates.
}
\description{
Resolves layout conflicts when the same individual appears in multiple places
(e.g., due to inbreeding loops). Keeps the layout point that is closest to a relevant
relative (mom, dad, or spouse) and removes links to others to avoid confusion in visualization.
}
\keyword{internal}
