% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdonut.R
\name{ggdonut}
\alias{ggdonut}
\title{Create donut plot.}
\usage{
ggdonut(
  data,
  group_key = NULL,
  count_type = c("count", "full"),
  fill_color = NULL,
  label_info = c("count", "ratio", "all"),
  label_split = "[[:space:]]+",
  label_color = "black",
  label_type = c("circle", "horizon", "none"),
  label_pos = c("in", "out"),
  label_gap = 0.05,
  labal_threshold = NULL,
  label_size = 4,
  border_color = "black",
  r0 = 1,
  r1 = 3,
  donut.label = TRUE,
  donut.label.size = 4,
  donut.label.color = "red"
)
}
\arguments{
\item{data}{Data frame contains full data or summarized data.}

\item{group_key}{Column used to summarize the data. Default: NULL.}

\item{count_type}{Data frame type, chosen from "count" and "full". "count" means summarized data and "full" means full data. Default: count.}

\item{fill_color}{Colors used. Default: NULL (conduct automatic selection).}

\item{label_info}{Label information type, chosen from count, ratio and all (count and ratio). Default: count.}

\item{label_split}{Pattern used to split the label, support regular expression. Default: space.}

\item{label_color}{Color of the label. Default: black.}

\item{label_type}{Label style, chosen from circle, horizon and none (no label). Default: circle.}

\item{label_pos}{Label position, chosen from in and out. Default: in.}

\item{label_gap}{Gap between label and pie plot, used when \code{label_pos} is out.}

\item{labal_threshold}{Threashold of the ratio to determine label position (in/out pie). Default: NULL.}

\item{label_size}{Size of the label. Default: 4.}

\item{border_color}{Border color. Default: black.}

\item{r0}{The radius of inner blank circle. Default: 1.}

\item{r1}{The radius of outer circle. Default: 3.}

\item{donut.label}{Logical value, whether to show total number in the center of the plot. Default: TRUE.}

\item{donut.label.size}{The label size of center label. Default: 4.}

\item{donut.label.color}{The color of center label. Default: red.}
}
\value{
A ggplot2 object.
}
\description{
Create donut plot.
}
\examples{
library(ggpie)
library(ggplot2)
data(diamonds)
# circle label and out of pie
ggdonut(
  data = diamonds, group_key = "cut", count_type = "full",
  label_info = "all", label_type = "circle",
  label_size = 4, label_pos = "out"
)
# circle label and in pie plot, with no split
ggdonut(
  data = diamonds, group_key = "cut", count_type = "full",
  label_info = "all", label_type = "circle", label_split = NULL,
  label_size = 4, label_pos = "in"
)
# horizon label and in pie plot, with no split
ggdonut(
  data = diamonds, group_key = "cut", count_type = "full",
  label_info = "all", label_type = "horizon", label_split = NULL,
  label_size = 4, label_pos = "in"
)
# horizon label and in pie plot
ggdonut(
  data = diamonds, group_key = "cut", count_type = "full",
  label_info = "all", label_type = "horizon",
  label_size = 4, label_pos = "in"
)
# horizon label and out of pie plot, with no split
ggdonut(
  data = diamonds, group_key = "cut", count_type = "full",
  label_info = "all", label_type = "horizon", label_split = NULL,
  label_size = 4, label_pos = "out"
)
# horizon label and out of pie plot
ggdonut(
  data = diamonds, group_key = "cut", count_type = "full",
  label_info = "all", label_type = "horizon",
  label_size = 4, label_pos = "out"
)
# with label threashold
ggdonut(
  data = diamonds, group_key = "cut", count_type = "full",
  label_info = "all", label_type = "horizon", label_split = NULL,
  label_size = 4, label_pos = "in", labal_threshold = 10
)
ggdonut(
  data = diamonds, group_key = "cut", count_type = "full",
  label_info = "all", label_type = "horizon",
  label_size = 4, label_pos = "in", labal_threshold = 10
)
}
