% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.r
\name{theme}
\alias{theme}
\title{Modify components of a theme}
\usage{
theme(line, rect, text, title, aspect.ratio, axis.title, axis.title.x,
  axis.title.x.top, axis.title.x.bottom, axis.title.y, axis.title.y.left,
  axis.title.y.right, axis.text, axis.text.x, axis.text.x.top,
  axis.text.x.bottom, axis.text.y, axis.text.y.left, axis.text.y.right,
  axis.ticks, axis.ticks.x, axis.ticks.x.top, axis.ticks.x.bottom,
  axis.ticks.y, axis.ticks.y.left, axis.ticks.y.right, axis.ticks.length,
  axis.line, axis.line.x, axis.line.x.top, axis.line.x.bottom, axis.line.y,
  axis.line.y.left, axis.line.y.right, legend.background, legend.margin,
  legend.spacing, legend.spacing.x, legend.spacing.y, legend.key,
  legend.key.size, legend.key.height, legend.key.width, legend.text,
  legend.text.align, legend.title, legend.title.align, legend.position,
  legend.direction, legend.justification, legend.box, legend.box.just,
  legend.box.margin, legend.box.background, legend.box.spacing,
  panel.background, panel.border, panel.spacing, panel.spacing.x,
  panel.spacing.y, panel.grid, panel.grid.major, panel.grid.minor,
  panel.grid.major.x, panel.grid.major.y, panel.grid.minor.x,
  panel.grid.minor.y, panel.ontop, plot.background, plot.title,
  plot.subtitle, plot.caption, plot.tag, plot.tag.position, plot.margin,
  strip.background, strip.background.x, strip.background.y,
  strip.placement, strip.text, strip.text.x, strip.text.y,
  strip.switch.pad.grid, strip.switch.pad.wrap, ..., complete = FALSE,
  validate = TRUE)
}
\arguments{
\item{line}{all line elements (\code{\link[=element_line]{element_line()}})}

\item{rect}{all rectangular elements (\code{\link[=element_rect]{element_rect()}})}

\item{text}{all text elements (\code{\link[=element_text]{element_text()}})}

\item{title}{all title elements: plot, axes, legends (\code{\link[=element_text]{element_text()}};
inherits from \code{text})}

\item{aspect.ratio}{aspect ratio of the panel}

\item{axis.title, axis.title.x, axis.title.y, axis.title.x.top, axis.title.x.bottom, axis.title.y.left, axis.title.y.right}{labels of axes (\code{\link[=element_text]{element_text()}}). Specify all axes' labels (\code{axis.title}),
labels by plane (using \code{axis.title.x} or \code{axis.title.y}), or individually
for each axis (using \code{axis.title.x.bottom}, \code{axis.title.x.top},
\code{axis.title.y.left}, \code{axis.title.y.right}). \code{axis.title.*.*} inherits from
\code{axis.title.*} which inherits from \code{axis.title}, which in turn inherits
from \code{text}}

\item{axis.text, axis.text.x, axis.text.y, axis.text.x.top, axis.text.x.bottom, axis.text.y.left, axis.text.y.right}{tick labels along axes (\code{\link[=element_text]{element_text()}}). Specify all axis tick labels (\code{axis.text}),
tick labels by plane (using \code{axis.text.x} or \code{axis.text.y}), or individually
for each axis (using \code{axis.text.x.bottom}, \code{axis.text.x.top},
\code{axis.text.y.left}, \code{axis.text.y.right}). \code{axis.text.*.*} inherits from
\code{axis.text.*} which inherits from \code{axis.text}, which in turn inherits
from \code{text}}

\item{axis.ticks, axis.ticks.x, axis.ticks.x.top, axis.ticks.x.bottom, axis.ticks.y, axis.ticks.y.left, axis.ticks.y.right}{tick marks along axes (\code{\link[=element_line]{element_line()}}). Specify all tick marks (\code{axis.ticks}),
ticks by plane (using \code{axis.ticks.x} or \code{axis.ticks.y}), or individually
for each axis (using \code{axis.ticks.x.bottom}, \code{axis.ticks.x.top},
\code{axis.ticks.y.left}, \code{axis.ticks.y.right}). \code{axis.ticks.*.*} inherits from
\code{axis.ticks.*} which inherits from \code{axis.ticks}, which in turn inherits
from \code{line}}

\item{axis.ticks.length}{length of tick marks (\code{unit})}

\item{axis.line, axis.line.x, axis.line.x.top, axis.line.x.bottom, axis.line.y, axis.line.y.left, axis.line.y.right}{lines along axes (\code{\link[=element_line]{element_line()}}). Specify lines along all axes (\code{axis.line}),
lines for each plane (using \code{axis.line.x} or \code{axis.line.y}), or individually
for each axis (using \code{axis.line.x.bottom}, \code{axis.line.x.top},
\code{axis.line.y.left}, \code{axis.line.y.right}). \code{axis.line.*.*} inherits from
\code{axis.line.*} which inherits from \code{axis.line}, which in turn inherits
from \code{line}}

\item{legend.background}{background of legend (\code{\link[=element_rect]{element_rect()}}; inherits
from \code{rect})}

\item{legend.margin}{the margin around each legend (\code{\link[=margin]{margin()}})}

\item{legend.spacing, legend.spacing.x, legend.spacing.y}{the spacing between legends (\code{unit}). \code{legend.spacing.x} & \code{legend.spacing.y}
inherit from \code{legend.spacing} or can be specified separately}

\item{legend.key}{background underneath legend keys (\code{\link[=element_rect]{element_rect()}};
inherits from \code{rect})}

\item{legend.key.size, legend.key.height, legend.key.width}{size of legend keys (\code{unit}); key background height & width inherit from
\code{legend.key.size} or can be specified separately}

\item{legend.text}{legend item labels (\code{\link[=element_text]{element_text()}}; inherits from
\code{text})}

\item{legend.text.align}{alignment of legend labels (number from 0 (left) to
1 (right))}

\item{legend.title}{title of legend (\code{\link[=element_text]{element_text()}}; inherits from
\code{title})}

\item{legend.title.align}{alignment of legend title (number from 0 (left) to
1 (right))}

\item{legend.position}{the position of legends ("none", "left", "right",
"bottom", "top", or two-element numeric vector)}

\item{legend.direction}{layout of items in legends ("horizontal" or
"vertical")}

\item{legend.justification}{anchor point for positioning legend inside plot
("center" or two-element numeric vector) or the justification according to
the plot area when positioned outside the plot}

\item{legend.box}{arrangement of multiple legends ("horizontal" or
"vertical")}

\item{legend.box.just}{justification of each legend within the overall
bounding box, when there are multiple legends ("top", "bottom", "left", or
"right")}

\item{legend.box.margin}{margins around the full legend area, as specified
using \code{\link[=margin]{margin()}}}

\item{legend.box.background}{background of legend area (\code{\link[=element_rect]{element_rect()}};
inherits from \code{rect})}

\item{legend.box.spacing}{The spacing between the plotting area and the
legend box (\code{unit})}

\item{panel.background}{background of plotting area, drawn underneath plot
(\code{\link[=element_rect]{element_rect()}}; inherits from \code{rect})}

\item{panel.border}{border around plotting area, drawn on top of plot so that
it covers tick marks and grid lines. This should be used with
\code{fill = NA}
(\code{\link[=element_rect]{element_rect()}}; inherits from \code{rect})}

\item{panel.spacing, panel.spacing.x, panel.spacing.y}{spacing between facet
panels (\code{unit}). \code{panel.spacing.x} & \code{panel.spacing.y} inherit from \code{panel.spacing}
or can be specified separately.}

\item{panel.grid, panel.grid.major, panel.grid.minor, panel.grid.major.x, panel.grid.major.y, panel.grid.minor.x, panel.grid.minor.y}{grid lines (\code{\link[=element_line]{element_line()}}). Specify major grid lines,
or minor grid lines separately (using \code{panel.grid.major} or \code{panel.grid.minor})
or individually for each axis (using \code{panel.grid.major.x}, \code{panel.grid.minor.x},
\code{panel.grid.major.y}, \code{panel.grid.minor.y}).  Y axis grid lines are horizontal
and x axis grid lines are vertical. \code{panel.grid.*.*} inherits from
\code{panel.grid.*} which inherits from \code{panel.grid}, which in turn inherits
from \code{line}}

\item{panel.ontop}{option to place the panel (background, gridlines) over
the data layers (\code{logical}). Usually used with a transparent or blank
\code{panel.background}.}

\item{plot.background}{background of the entire plot (\code{\link[=element_rect]{element_rect()}};
inherits from \code{rect})}

\item{plot.title}{plot title (text appearance) (\code{\link[=element_text]{element_text()}}; inherits
from \code{title}) left-aligned by default}

\item{plot.subtitle}{plot subtitle (text appearance) (\code{\link[=element_text]{element_text()}};
inherits from \code{title}) left-aligned by default}

\item{plot.caption}{caption below the plot (text appearance)
(\code{\link[=element_text]{element_text()}}; inherits from \code{title}) right-aligned by default}

\item{plot.tag}{upper-left label to identify a plot (text appearance)
(\code{\link[=element_text]{element_text()}}; inherits from \code{title}) left-aligned by default}

\item{plot.tag.position}{The position of the tag as a string ("topleft",
"top", "topright", "left", "right", "bottomleft", "bottom", "bottomright)
or a coordinate. If a string, extra space will be added to accommodate the
tag.}

\item{plot.margin}{margin around entire plot (\code{unit} with the sizes of
the top, right, bottom, and left margins)}

\item{strip.background, strip.background.x, strip.background.y}{background of facet labels (\code{\link[=element_rect]{element_rect()}};
inherits from \code{rect}). Horizontal facet background (\code{strip.background.x})
& vertical facet background (\code{strip.background.y}) inherit from
\code{strip.background} or can be specified separately}

\item{strip.placement}{placement of strip with respect to axes,
either "inside" or "outside". Only important when axes and strips are
on the same side of the plot.}

\item{strip.text, strip.text.x, strip.text.y}{facet labels (\code{\link[=element_text]{element_text()}};
inherits from  \code{text}). Horizontal facet labels (\code{strip.text.x}) & vertical
facet labels (\code{strip.text.y}) inherit from \code{strip.text} or can be specified
separately}

\item{strip.switch.pad.grid}{space between strips and axes when strips are
switched (\code{unit})}

\item{strip.switch.pad.wrap}{space between strips and axes when strips are
switched (\code{unit})}

\item{...}{additional element specifications not part of base ggplot2. If
supplied \code{validate} needs to be set to \code{FALSE}.}

\item{complete}{set this to \code{TRUE} if this is a complete theme, such as
the one returned by \code{\link[=theme_grey]{theme_grey()}}. Complete themes behave
differently when added to a ggplot object. Also, when setting
\code{complete = TRUE} all elements will be set to inherit from blank
elements.}

\item{validate}{\code{TRUE} to run \code{validate_element()}, \code{FALSE} to bypass checks.}
}
\description{
Themes are a powerful way to customize the non-data components of your
plots: i.e. titles, labels, fonts, background, gridlines, and legends.
Themes can be used to give plots a consistent customized look.
Modify a single plot's theme using \code{theme()}; see \code{\link[=theme_update]{theme_update()}} if
you want modify the active theme, to affect all subsequent plots. Theme
elements are documented together according to inheritance, read more
about theme inheritance below.
}
\section{Theme inheritance}{

Theme elements inherit properties from other theme elements heirarchically.
For example, \code{axis.title.x.bottom} inherits from \code{axis.title.x} which inherits
from \code{axis.title}, which in turn inherits from \code{text}. All text elements inherit
directly or indirectly from \code{text}; all lines inherit from
\code{line}, and all rectangular objects inherit from \code{rect}.
This means that you can modify the appearance of multiple elements by
setting a single high-level component.

Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.
}

\examples{
p1 <- ggplot(mtcars, aes(wt, mpg)) +
  geom_point() +
  labs(title = "Fuel economy declines as weight increases")
p1

# Plot ---------------------------------------------------------------------
p1 + theme(plot.title = element_text(size = rel(2)))
p1 + theme(plot.background = element_rect(fill = "green"))

# Panels --------------------------------------------------------------------

p1 + theme(panel.background = element_rect(fill = "white", colour = "grey50"))
p1 + theme(panel.border = element_rect(linetype = "dashed", fill = NA))
p1 + theme(panel.grid.major = element_line(colour = "black"))
p1 + theme(
  panel.grid.major.y = element_blank(),
  panel.grid.minor.y = element_blank()
)

# Put gridlines on top of data
p1 + theme(
  panel.background = element_rect(fill = NA),
  panel.grid.major = element_line(colour = "grey50"),
  panel.ontop = TRUE
)

# Axes ----------------------------------------------------------------------
p1 + theme(axis.line = element_line(size = 3, colour = "grey80"))
p1 + theme(axis.text = element_text(colour = "blue"))
p1 + theme(axis.ticks = element_line(size = 2))
p1 + theme(axis.ticks.length = unit(.25, "cm"))
p1 + theme(axis.title.y = element_text(size = rel(1.5), angle = 90))

\donttest{
# Legend --------------------------------------------------------------------
p2 <- ggplot(mtcars, aes(wt, mpg)) +
  geom_point(aes(colour = factor(cyl), shape = factor(vs))) +
  labs(
    x = "Weight (1000 lbs)",
    y = "Fuel economy (mpg)",
    colour = "Cylinders",
    shape = "Transmission"
   )
p2

# Position
p2 + theme(legend.position = "none")
p2 + theme(legend.justification = "top")
p2 + theme(legend.position = "bottom")

# Or place legends inside the plot using relative coordinates between 0 and 1
# legend.justification sets the corner that the position refers to
p2 + theme(
  legend.position = c(.95, .95),
  legend.justification = c("right", "top"),
  legend.box.just = "right",
  legend.margin = margin(6, 6, 6, 6)
)

# The legend.box properties work similarly for the space around
# all the legends
p2 + theme(
  legend.box.background = element_rect(),
  legend.box.margin = margin(6, 6, 6, 6)
)

# You can also control the display of the keys
# and the justification related to the plot area can be set
p2 + theme(legend.key = element_rect(fill = "white", colour = "black"))
p2 + theme(legend.text = element_text(size = 8, colour = "red"))
p2 + theme(legend.title = element_text(face = "bold"))

# Strips --------------------------------------------------------------------

p3 <- ggplot(mtcars, aes(wt, mpg)) +
  geom_point() +
  facet_wrap(~ cyl)
p3

p3 + theme(strip.background = element_rect(colour = "black", fill = "white"))
p3 + theme(strip.text.x = element_text(colour = "white", face = "bold"))
p3 + theme(panel.spacing = unit(1, "lines"))
}
}
\seealso{
\code{\link[=+.gg]{+.gg()}} and \code{\link{\%+replace\%}},
\code{\link[=element_blank]{element_blank()}}, \code{\link[=element_line]{element_line()}},
\code{\link[=element_rect]{element_rect()}}, and \code{\link[=element_text]{element_text()}} for
details of the specific theme elements.
}
