% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick-plot.r
\name{qplot}
\alias{qplot}
\alias{quickplot}
\title{Quick plot}
\usage{
qplot(
  x,
  y,
  ...,
  data,
  facets = NULL,
  margins = FALSE,
  geom = "auto",
  xlim = c(NA, NA),
  ylim = c(NA, NA),
  log = "",
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  asp = NA,
  stat = deprecated(),
  position = deprecated()
)

quickplot(
  x,
  y,
  ...,
  data,
  facets = NULL,
  margins = FALSE,
  geom = "auto",
  xlim = c(NA, NA),
  ylim = c(NA, NA),
  log = "",
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  asp = NA,
  stat = deprecated(),
  position = deprecated()
)
}
\arguments{
\item{x, y, ...}{Aesthetics passed into each layer}

\item{data}{Data frame to use (optional).  If not specified, will create
one, extracting vectors from the current environment.}

\item{facets}{faceting formula to use. Picks \code{\link[=facet_wrap]{facet_wrap()}} or
\code{\link[=facet_grid]{facet_grid()}} depending on whether the formula is one-
or two-sided}

\item{margins}{See \code{facet_grid()}: display marginal facets?}

\item{geom}{Character vector specifying geom(s) to draw. Defaults to
"point" if x and y are specified, and "histogram" if only x is specified.}

\item{xlim, ylim}{X and y axis limits}

\item{log}{Which variables to log transform ("x", "y", or "xy")}

\item{main, xlab, ylab}{Character vector (or expression) giving plot title,
x axis label, and y axis label respectively.}

\item{asp}{The y/x aspect ratio}

\item{stat, position}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\description{
\code{qplot()} is now deprecated in order to encourage the users to
learn \code{\link[=ggplot]{ggplot()}} as it makes it easier to create complex graphics.
}
\examples{
# Use data from data.frame
qplot(mpg, wt, data = mtcars)
qplot(mpg, wt, data = mtcars, colour = cyl)
qplot(mpg, wt, data = mtcars, size = cyl)
qplot(mpg, wt, data = mtcars, facets = vs ~ am)

\donttest{
set.seed(1)
qplot(1:10, rnorm(10), colour = runif(10))
qplot(1:10, letters[1:10])
mod <- lm(mpg ~ wt, data = mtcars)
qplot(resid(mod), fitted(mod))

f <- function() {
   a <- 1:10
   b <- a ^ 2
   qplot(a, b)
}
f()

# To set aesthetics, wrap in I()
qplot(mpg, wt, data = mtcars, colour = I("red"))

# qplot will attempt to guess what geom you want depending on the input
# both x and y supplied = scatterplot
qplot(mpg, wt, data = mtcars)
# just x supplied = histogram
qplot(mpg, data = mtcars)
# just y supplied = scatterplot, with x = seq_along(y)
qplot(y = mpg, data = mtcars)

# Use different geoms
qplot(mpg, wt, data = mtcars, geom = "path")
qplot(factor(cyl), wt, data = mtcars, geom = c("boxplot", "jitter"))
qplot(mpg, data = mtcars, geom = "dotplot")
}
}
