% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-manual.R, R/zxx.R
\name{scale_manual}
\alias{scale_colour_manual}
\alias{scale_fill_manual}
\alias{scale_size_manual}
\alias{scale_shape_manual}
\alias{scale_linetype_manual}
\alias{scale_linewidth_manual}
\alias{scale_alpha_manual}
\alias{scale_discrete_manual}
\alias{scale_color_manual}
\title{Create your own discrete scale}
\usage{
scale_colour_manual(
  ...,
  values,
  aesthetics = "colour",
  breaks = waiver(),
  na.value = "grey50"
)

scale_fill_manual(
  ...,
  values,
  aesthetics = "fill",
  breaks = waiver(),
  na.value = "grey50"
)

scale_size_manual(
  ...,
  values,
  breaks = waiver(),
  na.value = NA,
  aesthetics = "size"
)

scale_shape_manual(
  ...,
  values,
  breaks = waiver(),
  na.value = NA,
  aesthetics = "shape"
)

scale_linetype_manual(
  ...,
  values,
  breaks = waiver(),
  na.value = NA,
  aesthetics = "linetype"
)

scale_linewidth_manual(
  ...,
  values,
  breaks = waiver(),
  na.value = NA,
  aesthetics = "linewidth"
)

scale_alpha_manual(
  ...,
  values,
  breaks = waiver(),
  na.value = NA,
  aesthetics = "alpha"
)

scale_discrete_manual(aesthetics, ..., values, breaks = waiver())
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=discrete_scale]{discrete_scale}}
  \describe{
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} includes the levels in the factor. Please note that to display
every level in a legend, the layer should use \code{show.legend = TRUE}.}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{minor_breaks}}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (none for discrete, one minor break
between each major break for continuous)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks. Also
accepts rlang \link[rlang:as_function]{lambda} function notation. When
the function has two arguments, it will be given the limits and major
break positions.
}}
    \item{\code{labels}}{One of the options below. Please note that when \code{labels} is a
vector, it is highly recommended to also set the \code{breaks} argument as a
vector to protect against unintended mismatches.
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{guide}}{A function used to create a guide or its name. See
\code{\link[=guides]{guides()}} for more information.}
    \item{\code{call}}{The \code{call} used to construct the scale for reporting messages.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{values}{a set of aesthetic values to map data values to. The values
will be matched in order (usually alphabetical) with the limits of the
scale, or with \code{breaks} if provided. If this is a named vector, then the
values will be matched based on the names instead. Data values that don't
match will be given \code{na.value}.}

\item{aesthetics}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful, for
example, to apply colour settings to the \code{colour} and \code{fill} aesthetics at the
same time, via \code{aesthetics = c("colour", "fill")}.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output
}}

\item{na.value}{The aesthetic value to use for missing (\code{NA}) values}
}
\description{
These functions allow you to specify your own set of mappings from levels in the
data to aesthetic values.
}
\details{
The functions \code{scale_colour_manual()}, \code{scale_fill_manual()}, \code{scale_size_manual()},
etc. work on the aesthetics specified in the scale name: \code{colour}, \code{fill}, \code{size},
etc. However, the functions \code{scale_colour_manual()} and \code{scale_fill_manual()} also
have an optional \code{aesthetics} argument that can be used to define both \code{colour} and
\code{fill} aesthetic mappings via a single function call (see examples). The function
\code{scale_discrete_manual()} is a generic scale that can work with any aesthetic or set
of aesthetics provided via the \code{aesthetics} argument.
}
\section{Color Blindness}{

Many color palettes derived from RGB combinations (like the "rainbow" color
palette) are not suitable to support all viewers, especially those with
color vision deficiencies. Using \code{viridis} type, which is perceptually
uniform in both colour and black-and-white display is an easy option to
ensure good perceptive properties of your visualizations.
The colorspace package offers functionalities
\itemize{
\item to generate color palettes with good perceptive properties,
\item to analyse a given color palette, like emulating color blindness,
\item and to modify a given color palette for better perceptivity.
}

For more information on color vision deficiencies and suitable color choices
see the \href{https://arxiv.org/abs/1903.06490}{paper on the colorspace package}
and references therein.
}

\examples{
p <- ggplot(mtcars, aes(mpg, wt)) +
  geom_point(aes(colour = factor(cyl)))
p + scale_colour_manual(values = c("red", "blue", "green"))

# It's recommended to use a named vector
cols <- c("8" = "red", "4" = "blue", "6" = "darkgreen", "10" = "orange")
p + scale_colour_manual(values = cols)

# You can set color and fill aesthetics at the same time
ggplot(
  mtcars,
  aes(mpg, wt, colour = factor(cyl), fill = factor(cyl))
) +
  geom_point(shape = 21, alpha = 0.5, size = 2) +
  scale_colour_manual(
    values = cols,
    aesthetics = c("colour", "fill")
  )

# As with other scales you can use breaks to control the appearance
# of the legend.
p + scale_colour_manual(values = cols)
p + scale_colour_manual(
  values = cols,
  breaks = c("4", "6", "8"),
  labels = c("four", "six", "eight")
)

# And limits to control the possible values of the scale
p + scale_colour_manual(values = cols, limits = c("4", "8"))
p + scale_colour_manual(values = cols, limits = c("4", "6", "8", "10"))
}
\seealso{
The documentation for \link[=aes_linetype_size_shape]{differentiation related aesthetics}.

The documentation on \link[=aes_colour_fill_alpha]{colour aesthetics}.

The \href{https://ggplot2-book.org/scales-other#sec-scale-manual}{manual scales} and \href{https://ggplot2-book.org/scales-colour#sec-manual-colour}{manual colour scales sections} of the online ggplot2 book.

Other size scales: \code{\link[=scale_size]{scale_size()}}, \code{\link[=scale_size_identity]{scale_size_identity()}}.

Other shape scales: \code{\link[=scale_shape]{scale_shape()}}, \code{\link[=scale_shape_identity]{scale_shape_identity()}}.

Other linetype scales: \code{\link[=scale_linetype]{scale_linetype()}}, \code{\link[=scale_linetype_identity]{scale_linetype_identity()}}.

Other alpha scales: \code{\link[=scale_alpha]{scale_alpha()}}, \code{\link[=scale_alpha_identity]{scale_alpha_identity()}}.

Other colour scales: 
\code{\link{scale_alpha}()},
\code{\link{scale_colour_brewer}()},
\code{\link{scale_colour_continuous}()},
\code{\link{scale_colour_gradient}()},
\code{\link{scale_colour_grey}()},
\code{\link{scale_colour_hue}()},
\code{\link{scale_colour_identity}()},
\code{\link{scale_colour_steps}()},
\code{\link{scale_colour_viridis_d}()}
}
\concept{colour scales}
