% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-fit-broom-tb.R
\name{stat_fit_tb}
\alias{stat_fit_tb}
\title{Model-fit summary or ANOVA}
\usage{
stat_fit_tb(mapping = NULL, data = NULL, geom = "table_npc",
  method = "lm", method.args = list(formula = y ~ x),
  tb.type = "fit.summary", tb.vars = NULL, digits = 3,
  label.x = "center", label.y = "top", label.x.npc = NULL,
  label.y.npc = NULL, position = "identity", na.rm = FALSE,
  show.legend = FALSE, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs to be
set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{method}{character.}

\item{method.args}{list of arguments to pass to \code{method}.}

\item{tb.type}{character One of "fit.summary", "fit.anova" or "fit.coefs".}

\item{tb.vars}{character vector, optionally named, used to select and or
rename the columns of the table returned.}

\item{digits}{integer indicating the number of significant digits to be used.}

\item{label.x, label.y}{\code{numeric} Coordinates (in data units) to be used
for absolute positioning of the output. If too short they will be recycled.}

\item{label.x.npc, label.y.npc}{\code{numeric} with range 0..1 or character.
Coordinates to be used for positioning the output, expressed in "normalized
parent coordinates" or character string. If too short they will be
recycled.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{na.rm}{a logical indicating whether NA values should be stripped before
the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\description{
\code{stat_fit_tb} fits a model and returns a "tidy" version of
  the model's summary or ANOVA table, using package 'broom'. The annotation
  is added to the plots in tabular form.
}
\section{Computed variables}{
 The output of \code{\link[broom]{tidy}} is
  returned as a single "cell" in a tibble (i.e. a tibble nested within a
  tibble). The returned \code{data} object contains a single, containing the
  result from a single model fit to all data in a panel. If grouping is
  present, it is ignored.
}

\examples{
library(ggplot2)
# t-test example
x <- c(44.4, 45.9, 41.9, 53.3, 44.7, 44.1, 50.7, 45.2, 60.1)
group <- factor(c(rep("A", 4), rep("B", 5)))
my.df <- data.frame(x, group)

ggplot(my.df, aes(group, x)) +
  geom_point() +
  stat_fit_tb(method = "t.test",
              tb.vars = c("italic(t)" = "estimate", "italic(P)" = "p.value"),
              parse = TRUE)

}
\seealso{
\code{\link[broom]{tidy}} for details on how the tidying of the
  resulst of model fits is done. See \code{\link{geom_table}} for details
  on how the formating and location of the table can be adjusted.
}
