% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-continuous-Pvalue.r
\name{scale_y_Pvalue}
\alias{scale_y_Pvalue}
\alias{scale_y_FDR}
\alias{scale_x_Pvalue}
\alias{scale_x_FDR}
\title{Covenience scale for P-values}
\usage{
scale_y_Pvalue(..., name = expression(italic(P) - plain(value)),
  trans = NULL, breaks = NULL, labels = NULL, limits = c(1, 1e-20),
  oob = NULL, expand = NULL)

scale_y_FDR(..., name = "False discovery rate", trans = NULL,
  breaks = NULL, labels = NULL, limits = c(1, 1e-10), oob = NULL,
  expand = NULL)

scale_x_Pvalue(..., name = expression(italic(P) - plain(value)),
  trans = NULL, breaks = NULL, labels = NULL, limits = c(1, 1e-20),
  oob = NULL, expand = NULL)

scale_x_FDR(..., name = "False discovery rate", trans = NULL,
  breaks = NULL, labels = NULL, limits = c(1, 1e-10), oob = NULL,
  expand = NULL)
}
\arguments{
\item{...}{other named arguments passed to \code{scale_y_continuous}.}

\item{name}{The name of the scale without units, used for the axis-label.}

\item{trans}{Either the name of a transformation object, or the object itself. Use
NULL for the default.}

\item{breaks}{The positions of ticks or a function to generate them. Default
varies depending on argument passed to \code{log.base.labels}.}

\item{labels}{The tick labels or a function to generate them from the tick
positions. The default is function that uses the arguments passed to
\code{log.base.data} and \code{log.base.labels} to generate suitable
labels.}

\item{limits}{Use one of: \code{NULL} to use the default scale range, a numeric
vector of length two providing limits of the scale; NA to refer to the
existing minimum or maximum; a function that accepts the existing
(automatic) limits and returns new limits.}

\item{oob}{Function that handles limits outside of the scale limits (out of
bounds). The default squishes out-of-bounds values to the boundary.}

\item{expand}{Vector of range expansion constants used to add some padding
around the data, to ensure that they are placed some distance away from
the axes. The default is to expand the scale by 15\% on each end for
log-fold-data, so as to leave space for counts annotations.}
}
\description{
Scales for y aesthetic mapped to P-values as used in volcano plots with
transcriptomics and metabolomics data.
}
\details{
These scales only alter default arguments of
  \code{scale_x_continuous()} and \code{scale_y_continuous()}. Please, see
  documentation for \code{\link[ggplot2]{scale_continuous}} for details.
}
\examples{

set.seed(12346)
my.df <- data.frame(x = rnorm(50, sd = 4),
                    y = 10^-runif(50, min = 0, max = 20))

ggplot(my.df, aes(x, y)) +
  geom_point() +
  scale_x_logFC() +
  scale_y_Pvalue()

ggplot(my.df, aes(x, y)) +
  geom_point() +
  scale_x_logFC() +
  scale_y_FDR(limits = c(NA, 1e-20))

}
\seealso{
Other Functions for quadrant and volcano plots: \code{\link{FC_format}},
  \code{\link{geom_quadrant_lines}},
  \code{\link{outcome2factor}},
  \code{\link{scale_colour_outcome}},
  \code{\link{scale_shape_outcome}},
  \code{\link{stat_quadrant_counts}},
  \code{\link{xy_outcomes2factor}}
}
\concept{Functions for quadrant and volcano plots}
