% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-fit-broom.R
\name{stat_fit_tidy}
\alias{stat_fit_tidy}
\title{One row data frame with fitted parameter estimates}
\usage{
stat_fit_tidy(
  mapping = NULL,
  data = NULL,
  geom = "text_npc",
  method = "lm",
  method.args = list(formula = y ~ x),
  tidy.args = list(),
  label.x = "left",
  label.y = "top",
  hstep = 0,
  vstep = NULL,
  sanitize.names = FALSE,
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{method}{character or function.}

\item{method.args, tidy.args}{list of arguments to pass to \code{method},
and to [generics::tidy], respectively.}

\item{label.x, label.y}{\code{numeric} with range 0..1 or character.
Coordinates to be used for positioning the output, expressed in "normalized
parent coordinates" or character string. If too short they will be
recycled.}

\item{hstep, vstep}{numeric in npc units, the horizontal and vertical step
used between labels for different groups.}

\item{sanitize.names}{logical If true sanitize column names in the returned
\code{data} with R's \code{make.names()} function.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{na.rm}{a logical indicating whether NA values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\value{
The output of \code{tidy()} is returned after reshaping it into a
  single row. Grouping is respected, and the model fitted separately to each
  group of data. The returned \code{data} object has one row for each group
  within a panel. To use the intercept, note that output of \code{tidy()} is
  renamed from \code{(Intercept)} to \code{Intercept}. Otherwise, the names
  of the columns in the returned data are based on those returned by the
  \code{tidy()} method for the model fit class returned by the fit function.
  These will frequently differ from the name of values returned by the print
  methods corresponding to the fit or test function used. To explore the
  values returned by this statistic including the name of variables/columns,
  which vary depending on the model fitting function and model formula, we
  suggest the use of \code{\link[gginnards]{geom_debug}}. An example is shown
  below. Names of columns as returned by default are not always syntactically
  valid R names making it necessary to use back ticks to access them.
  Syntactically valid names are guaranteed if \code{sanitize.names = TRUE} is
  added to the call.

  To explore the values returned by this statistic, which vary depending on
  the model fitting function and model formula we suggest the use of
  \code{\link[gginnards]{geom_debug}}. An example is shown below.
}
\description{
\code{stat_fit_tidy} fits a model and returns a "tidy" version
  of the model's summary, using '\code{tidy()} methods from packages 'broom',
  'broom.mixed', or other sources. To add the summary in tabular form use
  \code{\link{stat_fit_tb}} instead of this statistic. When using
  \code{stat_fit_tidy()} you will most likely want to change the default
  mapping for label.
}
\details{
\code{stat_fit_tidy} together with \code{\link{stat_fit_glance}}
  and \code{\link{stat_fit_augment}}, based on package 'broom' can be used
  with a broad range of model fitting functions as supported at any given
  time by 'broom'. In contrast to \code{\link{stat_poly_eq}} which can
  generate text or expression labels automatically, for these functions the
  mapping of aesthetic \code{label} needs to be explicitly supplied in the
  call, and labels built on the fly.

  A ggplot statistic receives as data a data frame that is not the one passed
  as argument by the user, but instead a data frame with the variables mapped
  to aesthetics. In other words, it respects the grammar of graphics and
  consequently within arguments passed through \code{method.args} names of
  aesthetics like $x$ and $y$ should be used instead of the original variable
  names, while data is automatically passed the data frame. This helps ensure
  that the model is fitted to the same data as plotted in other layers.
}
\note{
The statistic \code{stat_fit_tidy} can be used only with
  \code{methods} that accept formulas under any formal parameter name and a
  \code{data} argument. Use \code{ggplot2::stat_smooth()} instead of
  \code{stat_fit_augment} in production code if the additional features are
  not needed.

Although arguments passed to parameter \code{tidy.args} will be
  passed to [generics::tidy()] whether they are silently ignored or obeyed
  depends on each specialization of [tidy()], so do carefully read the
  documentation for the version of [tidy()] corresponding to the `method`
  used to fit the model. You will also need to manually install the package,
  such as 'broom', where the tidier you intend to use are defined.
}
\section{Warning!}{
 Not all `glance()` methods are defined in package 'broom'.
  `glance()` specializations for mixed models fits of classes `lme`, `nlme`,
  `lme4`, and many others are defined in package 'broom.mixed'.
}

\section{Handling of grouping}{
 \code{stat_fit_tidy} applies the function
  given by \code{method} separately to each group of observations; in ggplot2
  factors mapped to aesthetics generate a separate group for each level.
  Because of this, \code{stat_fit_tidy} is not useful for annotating plots
  with results from \code{t.test()} or ANOVA or ANCOVA. In such cases use
  instead \code{stat_fit_tb()} which applies the model fitting per panel.
}

\examples{
# Package 'broom' needs to be installed to run these examples.
# We check availability before running them to avoid errors.

if (requireNamespace("broom", quietly = TRUE)) {
  broom.installed <- TRUE
  library(broom)
  library(quantreg)

# Inspecting the returned data using geom_debug()
  if (requireNamespace("gginnards", quietly = TRUE)) {
    library(gginnards)

# This provides a quick way of finding out the names of the variables that
# are available for mapping to aesthetics. This is specially important for
# this stat as these names depend on the specific tidy() method used, which
# depends on the method used, such as lm(), used to fit the model.

# Regression by panel, default column names
  ggplot(mtcars, aes(x = disp, y = mpg)) +
    stat_smooth(method = "lm", formula = y ~ x + I(x^2)) +
    geom_point(aes(colour = factor(cyl))) +
    stat_fit_tidy(method = "lm",
                  method.args = list(formula = y ~ x + I(x^2)),
                  geom = "debug")

# Regression by panel, sanitized column names
  ggplot(mtcars, aes(x = disp, y = mpg)) +
    stat_smooth(method = "lm", formula = y ~ x + I(x^2)) +
    geom_point(aes(colour = factor(cyl))) +
    stat_fit_tidy(method = "lm",
                  method.args = list(formula = y ~ x + I(x^2)),
                  geom = "debug", sanitize.names = TRUE)
  }
}

# Regression by panel example
if (broom.installed)
  ggplot(mtcars, aes(x = disp, y = mpg)) +
    stat_smooth(method = "lm") +
    geom_point(aes(colour = factor(cyl))) +
    stat_fit_tidy(method = "lm",
                  label.x = "right",
                  method.args = list(formula = y ~ x),
                  mapping = aes(label = sprintf("Slope = \%.3g\np-value = \%.3g",
                                                after_stat(x_estimate),
                                                after_stat(x_p.value))))

# Regression by group example
if (broom.installed)
  ggplot(mtcars, aes(x = disp, y = mpg, colour = factor(cyl))) +
    stat_smooth(method = "lm") +
    geom_point() +
    stat_fit_tidy(method = "lm",
                  label.x = "right",
                  method.args = list(formula = y ~ x),
                  mapping = aes(label = sprintf("Slope = \%.3g, p-value = \%.3g",
                                                after_stat(x_estimate),
                                                after_stat(x_p.value))))

# Weighted regression example
if (broom.installed)
  ggplot(mtcars, aes(x = disp, y = mpg, weight = cyl)) +
    stat_smooth(method = "lm") +
    geom_point(aes(colour = factor(cyl))) +
    stat_fit_tidy(method = "lm",
                  label.x = "right",
                  method.args = list(formula = y ~ x, weights = quote(weight)),
                  mapping = aes(label = sprintf("Slope = \%.3g\np-value = \%.3g",
                                                after_stat(x_estimate),
                                                after_stat(x_p.value))))

# Correlation test
if (broom.installed)
  ggplot(mtcars, aes(x = disp, y = mpg)) +
    stat_smooth(method = "lm") +
    geom_point() +
    stat_fit_tidy(method = "cor.test",
                  label.y = "bottom",
                  method.args = list(formula = ~ x + y),
                  mapping = aes(label = sprintf("R = \%.3g\np-value = \%.3g",
                                                after_stat(`_estimate`),
                                                after_stat(`_p.value`))))

# Quantile regression
if (broom.installed)
  ggplot(mtcars, aes(x = disp, y = mpg)) +
    stat_smooth(method = "lm") +
    geom_point() +
    stat_fit_tidy(method = "rq",
                  label.y = "bottom",
                  method.args = list(formula = y ~ x),
                  tidy.args = list(se.type = "nid"),
                  mapping = aes(label = sprintf("Slope = \%.3g\np-value = \%.3g",
                                                after_stat(x_estimate),
                                                after_stat(x_p.value))))

}
\seealso{
\code{\link[broom]{broom}} and \code{broom.mixed} for details on how
  the tidying of the result of model fits is done.

Other ggplot statistics for model fits: 
\code{\link{stat_fit_augment}()},
\code{\link{stat_fit_deviations}()},
\code{\link{stat_fit_glance}()},
\code{\link{stat_fit_residuals}()},
\code{\link{stat_fit_tb}()}
}
\concept{ggplot statistics for model fits}
