% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_prism_bracket.R
\name{guide_prism_bracket}
\alias{guide_prism_bracket}
\title{Axis guide with brackets}
\usage{
guide_prism_bracket(
  title = waiver(),
  check.overlap = FALSE,
  angle = NULL,
  n.dodge = 1,
  order = 0,
  position = waiver(),
  width = NULL,
  outside = TRUE
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[ggplot2:waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[ggplot2:labs]{labs()}} is used for the title.}

\item{check.overlap}{silently remove overlapping labels,
(recursively) prioritizing the first, last, and middle labels.}

\item{angle}{Compared to setting the angle in \code{\link[ggplot2:theme]{theme()}} / \code{\link[ggplot2:element]{element_text()}},
this also uses some heuristics to automatically pick the \code{hjust} and \code{vjust} that
you probably want.}

\item{n.dodge}{The number of rows (for vertical axes) or columns (for
horizontal axes) that should be used to render the labels. This is
useful for displaying labels that would otherwise overlap.}

\item{order}{Used to determine the order of the guides (left-to-right,
top-to-bottom), if more than one  guide must be drawn at the same location.}

\item{position}{Where this guide should be drawn: one of top, bottom,
left, or right.}

\item{width}{\code{numeric}. Controls the width of the bracket. Try
values between 0 and 1.}

\item{outside}{\code{logical}. Default is \code{TRUE} and brackets point
outwards. If \code{FALSE} the bracket crossbar is moved so the ticks appear
to point inwards towards the plotting area.}
}
\value{
Returns a \emph{prism_bracket} guide class object.
}
\description{
This guide turns the axis into brackets drawn around each axis label.
}
\details{
The number of brackets can be adjusted using the \code{breaks}
argument in \verb{scale_(x|y)_continuous()} or \verb{scale_(x|y)_discrete()}.
}
\examples{
library(ggplot2)

## base plot
base <- ggplot(mpg, aes(x = as.factor(cyl), y = hwy)) +
  geom_jitter(width = 0.2) +
  theme(axis.line = element_line(colour = "black"))

## use brackets on x axis
# if not specified, the width of the brackets is guessed
base + scale_x_discrete(guide = "prism_bracket")

# you can add brackets using the guide function as well
base + guides(x = "prism_bracket")

## works with coord_flip
base + scale_x_discrete(guide = "prism_bracket") +
  coord_flip()

## adjust bracket width
base + scale_x_discrete(guide = guide_prism_bracket(width = 0.12))

## make brackets point inward
base + scale_x_discrete(guide = guide_prism_bracket(width = 0.12, outside = FALSE))

## change colour with the usual axis.line, axis.ticks, axis.text elements
base + scale_x_discrete(guide = guide_prism_bracket(width = 0.12, outside = FALSE)) +
  theme(axis.line.x = element_line(colour = "red"),
        axis.ticks.x = element_line(colour = "blue"),
        axis.text.x = element_text(colour = "green"))
}
