% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_axis_hive.R
\name{geom_axis_hive}
\alias{geom_axis_hive}
\title{Draw rectangular bars and labels on hive axes}
\usage{
geom_axis_hive(mapping = NULL, data = NULL, position = "identity",
  label = TRUE, axis = TRUE, show.legend = NA, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{label}{Should the axes be labelled. Defaults to \code{TRUE}}

\item{axis}{Should a rectangle be drawn along the axis. Defaults to \code{TRUE}}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
This function lets you annotate the axes in a hive plot with labels and
color coded bars.
}
\section{Aesthetics}{

geom_axis_hive understand the following aesthetics.
\itemize{
\item{alpha}
\item{colour}
\item{fill}
\item{size}
\item{linetype}
\item{label_size}
\item{family}
\item{fontface}
\item{lineheight}
}
}

\examples{
# Plot the flare import graph as a hive plot
library(tidygraph)
flareGr <- as_tbl_graph(flare$imports) \%>\%
  mutate(
    type = dplyr::case_when(
      centrality_degree(mode = 'in') == 0 ~ 'Source',
      centrality_degree(mode = 'out') == 0 ~ 'Sink',
      TRUE ~ 'Both'
    )
  ) \%>\%
  activate(edges) \%>\%
  mutate(
    type = dplyr::case_when(
      grepl('flare.analytics', paste(.N()$name[from], .N()$name[to])) ~ 'Analytics',
      TRUE ~ 'Other'
    )
  )
ggraph(flareGr, 'hive', axis = type) +
  geom_edge_hive(aes(colour = type), edge_alpha = 0.1) +
  geom_axis_hive(aes(colour = type)) +
  coord_fixed()
}
\author{
Thomas Lin Pedersen
}
