% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_node_tile.R
\name{geom_node_tile}
\alias{geom_node_tile}
\title{Draw the rectangles in a treemap}
\usage{
geom_node_tile(
  mapping = NULL,
  data = NULL,
  position = "identity",
  show.legend = NA,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}
or \code{\link[ggplot2:aes_]{ggplot2::aes_()}}. By default x, y, width and height are mapped to
x, y, width and height in the node data.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
A treemap is a space filling layout that recursively divides a rectangle to
the children of the node. Often only the leaf nodes are drawn as nodes higher
up in the hierarchy would obscure what is below. \code{geom_treemap} is a
shorthand for \code{geom_node_treemap} as node is implicit in the case of
treemap drawing
}
\section{Aesthetics}{

\code{geom_treemap} understand the following aesthetics. Bold aesthetics are
automatically set, but can be overwritten.
\itemize{
\item \strong{x}
\item \strong{y}
\item \strong{width}
\item \strong{height}
\item alpha
\item colour
\item fill
\item size
\item stroke
\item filter
}
}

\examples{
# Create a graph of the flare class system
library(tidygraph)
flareGraph <- tbl_graph(flare$vertices, flare$edges) |>
  mutate(
    class = map_bfs_chr(node_is_root(), .f = function(node, dist, path, ...) {
      if (dist <= 1) {
        return(shortName[node])
      }
      path$result[[nrow(path)]]
    })
  )

ggraph(flareGraph, 'treemap', weight = size) +
  geom_node_tile(aes(fill = class, filter = leaf, alpha = depth), colour = NA) +
  geom_node_tile(aes(size = depth), colour = 'white') +
  scale_alpha(range = c(1, 0.5), guide = 'none') +
  scale_size(range = c(4, 0.2), guide = 'none')
}
\seealso{
Other geom_node_*: 
\code{\link{geom_node_arc_bar}()},
\code{\link{geom_node_circle}()},
\code{\link{geom_node_point}()},
\code{\link{geom_node_range}()},
\code{\link{geom_node_sf}()},
\code{\link{geom_node_text}()},
\code{\link{geom_node_voronoi}()}
}
\author{
Thomas Lin Pedersen
}
\concept{geom_node_*}
