% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01.npg.R
\name{pal_npg}
\alias{pal_npg}
\title{NPG Journal Color Palettes}
\usage{
pal_npg(palette = c("nrc"), alpha = 1)
}
\arguments{
\item{palette}{Palette type.
Currently there is one available option: \code{"nrc"}
(10-color palette inspired by \emph{Nature Reviews Cancer}).}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices]{rgb}} for details.}
}
\description{
Color palettes inspired by journals published by Nature Publishing Group,
such as \emph{Nature Reviews Cancer}.
}
\examples{
library("scales")
show_col(pal_npg("nrc")(10))
show_col(pal_npg("nrc", alpha = 0.6)(10))
}
\author{
Nan Xiao <\email{nanx@uchicago.edu}> |
<\href{http://nanx.me}{http://nanx.me}>
}

