% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_points.R
\name{draw_points}
\alias{draw_points}
\title{Draw points from a point CSV file (from ggsem Shiny app) on a ggplot2 object}
\usage{
draw_points(p, points_data, zoom_level = 1)
}
\arguments{
\item{p}{A ggplot2 object}

\item{points_data}{An object that stores the CSV file containing information about points from the ggsem Shiny app.}

\item{zoom_level}{A numeric value to control the zoom level of the plot. Default is 1.}
}
\value{
A ggplot object is returned as the function's output.
}
\description{
This function adds points onto any ggplot2 output (including your own plots not created from the ggsem Shiny app).
}
\examples{
library(ggplot2)

points_data <- data.frame(
x = 20, y = 300, shape = 'square', color = '#D0C5ED', size = 50,
border_color = '#9646D4', border_width = 2, alpha = 1,
locked = FALSE, lavaan = FALSE
)

p <- ggplot(mtcars) + geom_point(aes(mpg, disp))

draw_points(p, points_data, zoom_level = 1.2)

}
