% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_axis_range.R
\name{adjust_axis_range}
\alias{adjust_axis_range}
\title{Adjust Axis Range of a Plot of a ggplot2 Plot}
\usage{
adjust_axis_range(
  plot,
  x_range = NULL,
  y_range = NULL,
  buffer_percent = 0,
  fixed_aspect_ratio = TRUE
)
}
\arguments{
\item{plot}{A ggplot object. The plot whose axis ranges are to be adjusted.}

\item{x_range}{A numeric vector of length 2 specifying the desired x-axis range.
If \code{NULL}, the current x-axis range is retained. Default is \code{NULL}.}

\item{y_range}{A numeric vector of length 2 specifying the desired y-axis range.
If \code{NULL}, the current y-axis range is retained. Default is \code{NULL}.}

\item{buffer_percent}{A numeric value indicating the percentage of additional space
to add to each axis range as a buffer. Default is `0` (no buffer).}

\item{fixed_aspect_ratio}{A logical value indicating whether to maintain a fixed
aspect ratio for the plot. If \code{TRUE}, the function adjusts one axis to preserve
the aspect ratio. Default is \code{TRUE}.}
}
\value{
A modified ggplot object with adjusted axis ranges.
}
\description{
This function modifies the axis ranges of a ggplot object, with optional user-specified
ranges, additional buffers, and the ability to enforce a fixed aspect ratio. This is a modified
version of \code{adjust_axis_space()}.
}
\details{
- If `x_range` or `y_range` are provided, these values will override the current axis ranges.
- The `buffer_percent` parameter adds proportional space to the axis ranges, calculated
  as a percentage of the range's width or height.
- When `fixed_aspect_ratio` is `TRUE`, the function adjusts either the x-axis or y-axis
  to ensure the plot maintains a fixed aspect ratio.
}
\examples{
# CSV files from ggsem app
points_data <- data.frame(
x = 20, y = 20, shape = 'rectangle', color = '#D0C5ED', size = 50,
border_color = '#9646D4', border_width = 2, alpha = 1,
width_height_ratio = 1.6, orientation = 45, lavaan = FALSE,
network = FALSE, locked = FALSE, group = 1
)

lines_data <- data.frame(
x_start = 2, y_start = -2, x_end = 10, y_end = -2, ctrl_x = NA, ctrl_y = NA,
ctrl_x2 = NA, ctrl_y2 = NA, curvature_magnitude = NA, rotate_curvature = NA,
curvature_asymmetry = NA, type = 'Straight Line', color = '#000000',
end_color = NA, color_type = 'Single',
gradient_position = NA, width = 1.5, alpha = 1, arrow = FALSE,
arrow_type = NA, arrow_size = NA, two_way = FALSE, lavaan = FALSE,
network = FALSE, line_style = 'solid', locked = FALSE, group = 1
)

p <- csv_to_ggplot(graphics_data = list(points_data, lines_data),
              zoom_level = 1.2, # Value from the ggsem app
              horizontal_position = 0, # Value from the ggsem app
              element_order = c('lines', 'points')) # order priority: lines < points


adjust_axis_range(p, x_range = c(-30,30), y_range= c(-30,30))

}
