% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/north.R
\name{north}
\alias{north}
\title{North symbol}
\usage{
north(data = NULL, location = "topright", scale = 0.1, symbol = 1,
  x.min, x.max, y.min, y.max, anchor = NULL)
}
\arguments{
\item{data}{the same \code{\link{data.frame}} passed to \code{\link{ggplot}} to plot the map.}

\item{location}{string indicating the symbol's location in the plot. Possible options: "topright" (default), "bottomright", "bottomleft" and "topleft".}

\item{scale}{number between 0 and 1 to indicate the symbol size as a proportion of the map size (bounding box).}

\item{symbol}{number between 1 and 18 to choose a symbol (see \code{\link{northSymbols}}).}

\item{x.min}{if \code{data} is not defined, number with the minimum x coordinate. Useful for ggmap.}

\item{x.max}{if \code{data} is not defined, number with the maximum x coordinate. Useful for ggmap.}

\item{y.min}{if \code{data} is not defined, number with the minimum y coordinate. Useful for ggmap.}

\item{y.max}{if \code{data} is not defined, number with the maximum y coordinate. Useful for ggmap.}

\item{anchor}{named \code{\link{vector}} with coordinates to control the symbol position. For \code{location = "topright"}, \code{anchor} defines the coordinates of the symbol's topright corner and so forth. The x coordinate must be named as x and the y coordinate as y.}
}
\description{
Adds a north symbol to maps created with ggplot or ggmap.
}
\details{
North symbols are included in the plot with the \code{\link{annotation_custom}} function, which do not works when used together with an empty call to ggplot (see last example). When it is convenient to use an empty call to ggplot, use \code{\link{north2}} instead.
}
\examples{
library(rgdal); library(rgeos)
dsn <- system.file('extdata', package = 'ggsn')
map <- readOGR(dsn, 'sp')
map@data$id <- 1:nrow(map@data)
map.ff <- fortify(map, region = 'id')
map.df <- merge(map.ff, map@data, by = 'id')

ggplot(map.df, aes(long, lat, group = group, fill = nots)) +
    geom_polygon() +
    coord_equal() +
    geom_path() +
    north(map.df) +
    scale_fill_brewer(name = 'Animal abuse\\nnotifications', palette = 8)

ggplot(data = map.df, aes(long, lat, group = group, fill = nots)) +
    geom_polygon() +
    coord_equal() +
    geom_path() +
    north(map.df, location = 'bottomleft', symbol = 8) +
    scale_fill_brewer(name = 'Animal abuse\\nnotifications', palette = 8)

ggplot(map.df, aes(long, lat, group = group, fill = nots)) +
    geom_polygon() +
    coord_equal() +
    geom_path() +
    north(data = map.df, location = 'bottomright', scale = 0.2, symbol = 14,
          anchor = c(x = -46.4, y = -23.9)) +
    scale_fill_brewer(name = 'Animal abuse\\nnotifications', palette = 8)

\dontrun{
ggplot() +
   geom_polygon(data = map.df, aes(long, lat, group = group, fill = nots)) +
   coord_equal() +
   geom_path() +
   north(map.df)
}
}

