% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-labels-texts.R
\name{axis_labels}
\alias{axis_labels}
\alias{axis_labels_uk}
\alias{axis_labels_uk_comma}
\alias{axis_labels_none}
\title{Default text for axis labels}
\usage{
axis_labels()

axis_labels_uk()

axis_labels_uk_comma()

axis_labels_none()
}
\value{
A character vector
}
\description{
Texts used by default for axis labels in plots are recalled from character
vectors returned by these functions. The aim is that their default values can
be easily changed or translated to other languages. They contain only the
text part, but not symbols or units of expression.
}
\details{
By default \code{axis_labes()} contains a copy of
  \code{axis_labels_uk_comma()}. By assigning to this name a user function
  that returns a named character vector using the same names as those
  returned by these funtcions, it is possible to temporarily change
  the default texts.
}
\examples{
axis_labels()[["w.length"]] # ending in a comma
axis_labels <- axis_labels_uk
axis_labels()[["w.length"]] # no comma

}
