% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-cps-spct.R
\name{cps_label}
\alias{cps_label}
\title{Counts-per-second axis labels}
\usage{
cps_label(
  unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels()[["cps"]],
  scaled = FALSE,
  normalized = FALSE
)
}
\arguments{
\item{unit.exponent}{integer}

\item{format}{character string, "R", "R.expresion", "R.character", or
"LaTeX".}

\item{label.text}{character Textual portion of the labels.}

\item{scaled}{logical If \code{TRUE} relative units are assumed.}

\item{normalized}{logical (\code{FALSE}) or numeric Normalization wavelength
in manometers (nm).}
}
\value{
a character string or an R expression.
}
\description{
Generate pixel response rate axis labels in cps units. Output can be selected
as character, expression (R default devices) or LaTeX (for tikz device).
}
\examples{

cps_label()
cps_label(3)
cps_label(format = "R.expression")
cps_label(format = "R.character")
cps_label(format = "LaTeX")
cps_label(3, format = "LaTeX")

}
