% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-filter-spct.R
\name{Tfr_label}
\alias{Tfr_label}
\alias{Tfr_internal_label}
\alias{Tfr_total_label}
\title{Transmittance axis labels}
\usage{
Tfr_label(
  unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = NULL,
  scaled = FALSE,
  normalized = FALSE,
  Tfr.type
)

Tfr_internal_label(
  unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = NULL,
  scaled = FALSE,
  normalized = FALSE
)

Tfr_total_label(
  unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = NULL,
  scaled = FALSE,
  normalized = FALSE
)
}
\arguments{
\item{unit.exponent}{integer}

\item{format}{character string, "R", "R.expresion", "R.character", or
"LaTeX".}

\item{label.text}{character Textual portion of the labels.}

\item{scaled}{logical If \code{TRUE} relative units are assumed.}

\item{normalized}{logical (\code{FALSE}) or numeric Normalization wavelength
in manometers (nm).}

\item{Tfr.type}{character, either "total" or "internal".}
}
\value{
a character string or an R expression.
}
\description{
Generate cps axis labels in SI units,
using SI scale factors. Output can be selected as character, expression (R
default devices) or LaTeX (for tikz device).
}
\note{
Default for \code{label.text} depends on the value passed as argument
  to \code{Tfr.type}.
}
\examples{

Tfr_label(Tfr.type = "internal")
Tfr_label(Tfr.type = "total")


Tfr_internal_label()
Tfr_internal_label(-2)
Tfr_internal_label(-3)
Tfr_internal_label(format = "R.expression")
Tfr_internal_label(format = "LaTeX")
Tfr_internal_label(-3, format = "LaTeX")


Tfr_total_label()
Tfr_total_label(-2)
Tfr_total_label(-3)
Tfr_total_label(format = "R.expression")
Tfr_total_label(format = "LaTeX")
Tfr_total_label(-3, format = "LaTeX")

}
