% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoration.R
\name{decoration}
\alias{decoration}
\title{Add decorations to spectrum plot (private)}
\usage{
decoration(
  w.band,
  y.max,
  y.min,
  x.max,
  x.min,
  x.expanse = x.max - x.min,
  y.expanse = y.max - y.min,
  annotations,
  span,
  strict = is.null(span),
  wls.target = "HM",
  label.qty,
  label.mult = 1,
  summary.label,
  unit.out = NULL,
  time.unit = NULL,
  text.size = 2.5,
  label.color = NULL,
  chroma.type = "CMF",
  pos.shift = 0,
  na.rm = TRUE
)
}
\arguments{
\item{w.band}{waveband object or list of waveband objects}

\item{y.max, y.min, x.max, x.min, x.expanse, y.expanse}{numeric}

\item{annotations}{character vector}

\item{span}{numeric}

\item{strict}{logical}

\item{wls.target}{numeric or character vector}

\item{label.qty}{character}

\item{summary.label}{character}

\item{text.size}{numeric}

\item{label.color}{color definition or name}

\item{chroma.type}{character one of "CMF" (color matching function) or "CC"
(color coordinates) or a \code{\link[photobiology]{chroma_spct}} object.}

\item{pos.shift}{numeric}

\item{na.rm}{logical}

\item{nudge_npcx, nudge_npcy}{numeric}
}
\value{
A list of ggplot "components" that can be added to a ggplot object
  with operator \code{+}. The length of the list depends on the value of argument
  \code{annotations}.
}
\description{
Add decorations to plots generated by the \code{autoplot()} methods defined in
this package. It collects code that is common to \code{autoplot()} methods for
different types of spectra but as it may change in the future it is not
exported.
}
\details{
Vectors of character strings passed as argument to
\code{annotations} are parsed so that if the first member string is
\code{"+"}, the remaining members are added to the current default for
annotations; if it is \code{"-"} the remaining members are removed from the
current default for annotations; and if it is \code{"="} the remaining
members become the new default. If the first member is none of these three
strings, the whole vector becomes the new default. If \code{annotations} is
\code{NULL} the annotations are reset to the package defaults. When removing
annotations \code{"title*"}, \code{"peaks*"} and \code{"valleys*"} will
remove any variation of these annotations. The string \code{""} means no
annotations while \code{"reserve.space"} means no annotations but expand y
scale to reserve space for annotations. These two values take precedence over
any other values in the character vector. The order of the names of
annotations has no meaning: the vector is interpreted as a set except for the
three possible "operators" at position 1.
}
\section{Plot Annotations}{
 The recognized annotation names are: \code{"summaries"}, \code{"peaks"},
  \code{"peak.labels"}, \code{"valleys"}, \code{"valley.labels"},
  \code{"wls"}, \code{"wls.labels"}, \code{"colour.guide"},
  \code{"color.guide"}, \code{"boxes"}, \code{"segments"}, \code{"labels"}.
  In addition, \code{"+"} is interpreted as a request to add to the already
  present default annotations, \code{"-"} as request to remove annotations
  and \code{"="} or missing\code{"+"} and \code{"-"} as a request to reset
  annotations to those requested. If used, \code{"+"}, \code{"-"} or
  \code{"="} must be the first member of a character vector, and followed by
  one or more of the names given above. To simultaneously add and remove
  annotations one can pass a \code{list} containing \code{character} vectors
  each assembled as described. The vectors are applied in the order they
  appear in the list. To disable all annotations pass \code{""} or
  \code{c("=", "")} as argument. Adding a variation of an annotation already
  present, replaces the existing one automatically: e.g., adding
  \code{"peak.labels"} replaces\code{"peaks"} if present.
}

\keyword{internal}
