% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_bf_tests.R
\name{bf_corr_test}
\alias{bf_corr_test}
\title{Bayesian correlation test.}
\usage{
bf_corr_test(data, x, y, bf.prior = 0.707, caption = NULL,
  output = "null", k = 2, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{second continuous variable}

\item{y}{first continuous variable}

\item{bf.prior}{A number between 0.5 and 2 (default \code{0.707}), the prior width
to use in calculating Bayes factors.}

\item{caption}{Text to display as caption (will be displayed on top of the
bayes factor caption/message).}

\item{output}{Can either be \code{"null"} (or \code{"caption"} or \code{"H0"}, which will
contain text for evidence in favor of the null hypothesis or H0)  or
\code{"alternative"} (or \code{"title"} or \code{"H1"}) or \code{"results"}, which will return
a dataframe with results all the details).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{further arguments to be passed to or from methods.}
}
\description{
Bayesian correlation test.
}
\examples{

# for reproducibility
set.seed(123)

# to get caption (default)
bf_corr_test(
  data = anscombe,
  x = x1,
  y = y4,
  bf.prior = 1
)

# to see results
bf_corr_test(
  data = anscombe,
  x = x1,
  y = y4,
  bf.prior = 0.8,
  output = "results"
)
}
\seealso{
\code{\link{bf_contingency_tab}}, \code{\link{bf_oneway_anova}},
\code{\link{bf_two_sample_ttest}}
}
\author{
Indrajeet Patil
}
