% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_ggpiestats.R
\name{grouped_ggpiestats}
\alias{grouped_ggpiestats}
\title{Grouped pie charts with statistical tests}
\usage{
grouped_ggpiestats(grouping.var, title.prefix = "Group", data, main,
  condition = NULL, factor.levels = NULL, stat.title = NULL,
  caption = NULL, legend.title = NULL, facet.wrap.name = NULL, k = 3,
  facet.proptest = TRUE, messages = TRUE, ...)
}
\arguments{
\item{grouping.var}{Grouping variable.}

\item{title.prefix}{Character specifying the prefix text for the fixed plot
title (name of each factor level) (Default: \code{"Group"}).}

\item{data}{The data as a data frame.}

\item{main}{A string naming the variable to use as the rows in the
contingency table.}

\item{condition}{A string naming the variable to use as the columns in the
contingency table.}

\item{factor.levels}{A character vector with labels for factor levels of
\code{main} variable.}

\item{stat.title}{Title for the effect being investigated with the chi-square
test.}

\item{caption}{The text for the plot caption.}

\item{legend.title}{Title of legend.}

\item{facet.wrap.name}{The text for the facet_wrap variable label.}

\item{k}{Number of decimal places expected for results.}

\item{facet.proptest}{Decides whether proprotion test for \code{main} variable is
to be carried out for each level of \code{condition} (Default: \code{TRUE}).}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{Arguments passed on to \code{combine_plots}
\describe{
  \item{title.text}{String or plotmath expression to be drawn as title for the
\emph{combined plot}.}
  \item{title.color}{Text color for title.}
  \item{title.size}{Point size of title text.}
  \item{title.vjust}{Vertical justification for title. Default = 0.5 (centered
on y). 0 = baseline at y, 1 = ascender at y.}
  \item{title.hjust}{Horizontal justification for title. Default = 0.5
(centered on x). 0 = flush-left at x, 1 = flush-right.}
  \item{title.fontface}{The font face ("plain", "bold", etc.) for title.}
  \item{caption.text}{String or plotmath expression to be drawn as the caption
for the \emph{combined plot}.}
  \item{caption.color}{Text color for caption.}
  \item{caption.size}{Point size of title text.}
  \item{caption.vjust}{Vertical justification for caption. Default = \code{0.5}
(centered on y). \code{0} = baseline at y, \code{1} = ascender at y.}
  \item{caption.hjust}{Horizontal justification for caption. Default = \code{0.5}
(centered on x). \code{0} = flush-left at x, \code{1} = flush-right.}
  \item{caption.fontface}{The font face (\code{"plain"}, \code{"bold"}, \code{"italic"},
\code{"bold.italic"}) for caption.}
  \item{sub.text}{The label with which the \emph{combined plot} should be annotated.
Can be a plotmath expression.}
  \item{sub.color}{Text color for annotation label.}
  \item{sub.size}{Point size of annotation text.}
  \item{sub.x}{The x position of annotation label.}
  \item{sub.y}{The y position of annotation label.}
  \item{sub.hjust}{Horizontal justification for annotation label.}
  \item{sub.vjust}{Vertical justification for annotation label.}
  \item{sub.vpadding}{Vertical padding. The total vertical space added to the
label, given in grid units. By default, this is added equally above and
below the label. However, by changing the y and vjust parameters, this can
be changed.}
  \item{sub.fontface}{The font face (\code{"plain"}, \code{"bold"}, \code{"italic"},
\code{"bold.italic"}) for the annotation label.}
  \item{sub.angle}{Angle at which annotation label is to be drawn.}
  \item{sub.lineheight}{Line height of annotation label.}
  \item{title.caption.rel.heights}{Numerical vector of relative columns heights
while combining (title, plot, caption).}
  \item{title.rel.heights}{Numerical vector of relative columns heights while
combining (title, plot).}
  \item{caption.rel.heights}{Numerical vector of relative columns heights while
combining (plot, caption).}
}}
}
\description{
Helper function for \code{ggstatsplot::ggpiestats} to apply this
function across multiple levels of a given factor and combining the
resulting plots using \code{ggstatsplot::combine_plots}.
}
\examples{

# grouped one-sample proportion tests
ggstatsplot::grouped_ggpiestats(
data = mtcars,
grouping.var = am,
main = cyl
)

}
\seealso{
\code{\link{ggpiestats}}
}
\author{
Indrajeet Patil
}
