% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbetweenstats.R
\name{ggbetweenstats}
\alias{ggbetweenstats}
\title{Violin plots for group or condition comparisons in between-subjects
designs.}
\usage{
ggbetweenstats(data, x, y, plot.type = "boxviolin",
  type = "parametric", effsize.type = "unbiased",
  effsize.noncentral = FALSE, bf.prior = 0.707, bf.message = FALSE,
  xlab = NULL, ylab = NULL, caption = NULL, title = NULL,
  sample.size.label = TRUE, k = 3, var.equal = FALSE, nboot = 100,
  tr = 0.1, mean.label.size = 3, mean.label.fontface = "bold",
  mean.label.color = "black", notch = FALSE, notchwidth = 0.5,
  linetype = "solid", outlier.tagging = FALSE, outlier.label = NULL,
  outlier.label.color = "black", outlier.color = "black",
  outlier.coef = 1.5, mean.plotting = TRUE, mean.ci = FALSE,
  mean.size = 5, mean.color = "darkred",
  ggtheme = ggplot2::theme_bw(), ggstatsplot.layer = TRUE,
  package = "RColorBrewer", palette = "Dark2", direction = 1,
  point.jitter.width = NULL, point.jitter.height = 0.1,
  point.dodge.width = 0.6, messages = TRUE)
}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken.}

\item{x}{The grouping variable.}

\item{y}{The response - a vector of length the number of rows of \code{x}.}

\item{plot.type}{Character describing the \emph{type} of plot. Currently supported
plots are \code{"box"} (for pure boxplots), \code{"violin"} (for pure violin plots),
and \code{"boxviolin"} (for a mix of box and violin plots; default).}

\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"biased"} (\code{"d"} for Cohen's \emph{d} for \strong{t-test};
\code{"partial_eta"} for partial eta-squared for \strong{anova}) or \code{"unbiased"}
(\code{"g"} Hedge's \emph{g} for \strong{t-test}; \code{"partial_omega"} for partial
omega-squared for \strong{anova})).}

\item{effsize.noncentral}{Logical indicating whether to use non-central
\emph{t}-distributions for computing the 95% confidence interval for Cohen's \emph{d}
or Hedge's \emph{g} (Default: \code{FALSE}).}

\item{bf.prior}{A number between 0.5 and 2 (default \code{0.707}), the prior width
to use in calculating Bayes factors.}

\item{bf.message}{Logical. Decides whether to display Bayes Factor in favor
of \emph{null} hypothesis \strong{for parametric test} (Default: \code{bf.message = FALSE}).}

\item{xlab}{Label for \code{x} axis variable.}

\item{ylab}{Label for \code{y} axis variable.}

\item{caption}{The text for the plot caption.}

\item{title}{The text for the plot title.}

\item{sample.size.label}{Logical that decides whether sample size information
should be displayed for each level of the grouping variable \code{x} (Default:
\code{TRUE}).}

\item{k}{Number of digits after decimal point (should be an integer) (Default: \code{k = 3}).}

\item{var.equal}{a logical variable indicating whether to treat the
    variances in the samples as equal.  If \code{TRUE}, then a simple F
    test for the equality of means in a one-way analysis of variance is
    performed.  If \code{FALSE}, an approximate method of Welch (1951)
    is used, which generalizes the commonly known 2-sample Welch test to
    the case of arbitrarily many samples.}

\item{nboot}{Number of bootstrap samples for computing effect size (Default:
\code{100}).}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. If you
get error stating "Standard error cannot be computed because of Winsorized
variance of 0 (e.g., due to ties). Try to decrease the trimming level.",
try to play around with the value of \code{tr}, which is by default set to
\code{0.1}. Lowering the value might help.}

\item{mean.label.size, mean.label.fontface, mean.label.color}{Aesthetics for
the label displaying mean. Defaults: \code{3}, \code{"bold"},\code{"black"}, respectively.}

\item{notch}{A logical. If \code{FALSE} (default), a standard box plot will be
displayed. If \code{TRUE}, a notched box plot will be used. Notches are used to
compare groups; if the notches of two boxes do not overlap, this suggests
that the medians are significantly different. In a notched box plot, the
notches extend \code{1.58 * IQR / sqrt(n)}. This gives a roughly \code{95\%} confidence
interval for comparing medians. IQR: Inter-Quartile Range.}

\item{notchwidth}{For a notched box plot, width of the notch relative to the
body (default \code{0.5}).}

\item{linetype}{Character strings (\code{"blank"}, \code{"solid"}, \code{"dashed"},
\code{"dotted"}, \code{"dotdash"}, \code{"longdash"}, and \code{"twodash"}) specifying the type
of line to draw box plots (Default: \code{"solid"}). Alternatively, the numbers
\code{0} to \code{6} can be used (\code{0} for "blank", \code{1} for "solid", etc.).}

\item{outlier.tagging}{Decides whether outliers should be tagged (Default:
\code{FALSE}).}

\item{outlier.label}{Label to put on the outliers that have been tagged.}

\item{outlier.label.color}{Color for the label to to put on the outliers that
have been tagged (Default: \code{"black"}).}

\item{outlier.color}{Default aesthetics for outliers (Default: \code{"black"}).}

\item{outlier.coef}{Coefficient for outlier detection using Tukey's method.
With Tukey's method, outliers are below (1st Quartile) or above (3rd
Quartile) \code{outlier.coef} times the Inter-Quartile Range (IQR) (Default:
\code{1.5}).}

\item{mean.plotting}{Logical that decides whether mean is to be highlighted
and its value to be displayed (Default: \code{TRUE}).}

\item{mean.ci}{Logical that decides whether 95% confidence interval for mean
is to be displayed (Default: \code{FALSE}).}

\item{mean.size}{Point size for the data point corresponding to mean
(Default: \code{5}).}

\item{mean.color}{Color for the data point corresponding to mean (Default:
\code{"darkred"}).}

\item{ggtheme}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_economist()},
\code{hrbrthemes::theme_ipsum_ps()}, \code{ggthemes::theme_fivethirtyeight()}, etc.).}

\item{ggstatsplot.layer}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}).}

\item{package}{Name of package from which the palette is desired as string
or symbol.}

\item{palette}{If a character string (e.g., \code{"Set1"}), will use that named
palette. If a number, will index into the list of palettes of appropriate
type. Default palette is \code{"Dark2"}.}

\item{direction}{Either \code{1} or \code{-1}. If \code{-1} the palette will be reversed.}

\item{point.jitter.width}{Numeric specifying the degree of jitter in \code{x}
direction. Defaults to \code{40\%} of the resolution of the data.}

\item{point.jitter.height}{Numeric specifying the degree of jitter in \code{y}
direction. Defaults to \code{0.1}.}

\item{point.dodge.width}{Numeric specifying the amount to dodge in the \code{x}
direction. Defaults to \code{0.60}.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
}
\description{
A combination of box and violin plots along with jittered data
points for between-subjects designs with statistical details included in
the plot as a subtitle.
}
\details{
For parametric tests, Welch's ANOVA/t-test are used as a default. References:
\itemize{
\item ANOVA: Delacre, Leys, Mora, & Lakens, \emph{PsyArXiv}, 2018
\item t-test: Delacre, Lakens, & Leys, \emph{International Review of Social Psychology}, 2017
}

If robust tests are selected, following tests are used is .
\itemize{
\item ANOVA: one-way ANOVA on trimmed means (see \code{?WRS2::t1way})
\item t-test: Yuen's test for trimmed means (see \code{?WRS2::yuen})
}

Variant of this function \code{ggwithinstats} is currently under work. You \emph{can}
still use this function just to prepare the \strong{plot} for exploratory data
analysis, but the statistical details displayed in the subtitle will be
incorrect. You can remove them by adding \code{+ ggplot2::labs(subtitle = NULL)}.
}
\examples{

# to get reproducible results from bootstrapping
set.seed(123)

# simple function call with the defaults
ggstatsplot::ggbetweenstats(
  data = mtcars,
  x = am,
  y = mpg,
  title = "Fuel efficiency by type of car transmission",
  caption = "Transmission (0 = automatic, 1 = manual)",
  bf.message = TRUE
)

# more detailed function call
ggstatsplot::ggbetweenstats(
  data = datasets::morley,
  x = Expt,
  y = Speed,
  plot.type = "box",
  xlab = "The experiment number",
  ylab = "Speed-of-light measurement",
  outlier.tagging = TRUE,
  outlier.label = Run,
  ggtheme = ggthemes::theme_few(),
  ggstatsplot.layer = FALSE
)
}
\references{
\url{https://cran.r-project.org/package=ggstatsplot/vignettes/ggbetweenstats.html}
}
\seealso{
\code{\link{grouped_ggbetweenstats}}
}
\author{
Indrajeet Patil
}
