% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_ggwithinstats.R
\name{grouped_ggwithinstats}
\alias{grouped_ggwithinstats}
\title{Violin plots for group or condition comparisons in within-subjects
designs repeated across all levels of a grouping variable.}
\usage{
grouped_ggwithinstats(
  data,
  x,
  y,
  grouping.var,
  outlier.label = NULL,
  title.prefix = NULL,
  output = "plot",
  ...,
  plotgrid.args = list(),
  title.text = NULL,
  title.args = list(size = 16, fontface = "bold"),
  caption.text = NULL,
  caption.args = list(size = 10),
  sub.text = NULL,
  sub.args = list(size = 12)
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{grouping.var}{A single grouping variable (can be entered either as a
bare name \code{x} or as a string \code{"x"}).}

\item{outlier.label}{Label to put on the outliers that have been tagged. This
\strong{can't} be the same as \code{x} argument.}

\item{title.prefix}{Character string specifying the prefix text for the fixed
plot title (name of each factor level) (Default: \code{NULL}). If \code{NULL}, the
variable name entered for \code{grouping.var} will be used.}

\item{output}{Character that describes what is to be returned: can be
\code{"plot"} (default) or \code{"subtitle"} or \code{"caption"}. Setting this to
\code{"subtitle"} will return the expression containing statistical results. If
you have set \code{results.subtitle = FALSE}, then this will return a \code{NULL}.
Setting this to \code{"caption"} will return the expression containing details
about Bayes Factor analysis, but valid only when \code{type = "parametric"} and
\code{bf.message = TRUE}, otherwise this will return a \code{NULL}. For functions
\code{ggpiestats} and \code{ggbarstats}, setting \code{output = "proptest"} will return a
dataframe containing results from proportion tests.}

\item{...}{
  Arguments passed on to \code{\link[=ggwithinstats]{ggwithinstats}}
  \describe{
    \item{\code{point.path}}{Logical that decides whether individual data
points and means, respectively, should be connected using \code{geom_path}. Both
default to \code{TRUE}. Note that \code{point.path} argument is relevant only when
there are two groups (i.e., in case of a \emph{t}-test). In case of large number
of data points, it is advisable to set \code{point.path = FALSE} as these lines
can overwhelm the plot.}
    \item{\code{mean.path}}{Logical that decides whether individual data
points and means, respectively, should be connected using \code{geom_path}. Both
default to \code{TRUE}. Note that \code{point.path} argument is relevant only when
there are two groups (i.e., in case of a \emph{t}-test). In case of large number
of data points, it is advisable to set \code{point.path = FALSE} as these lines
can overwhelm the plot.}
    \item{\code{mean.path.args}}{A list of additional aesthetic
arguments passed on to \code{geom_path} connecting raw data points and mean
points.}
    \item{\code{point.path.args}}{A list of additional aesthetic
arguments passed on to \code{geom_path} connecting raw data points and mean
points.}
    \item{\code{type}}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}
    \item{\code{pairwise.comparisons}}{Logical that decides whether pairwise comparisons
are to be displayed (default: \code{FALSE}). Please note that only
\strong{significant} comparisons will be shown by default. To change this
behavior, select appropriate option with \code{pairwise.display} argument. The
pairwise comparison dataframes are prepared using the
\code{pairwiseComparisons::pairwise_comparisons} function. For more details
about pairwise comparisons, see the documentation for that function.}
    \item{\code{pairwise.annotation}}{Character that decides the annotations to use for
pairwise comparisons. Either \code{"p.value"} (default) or \code{"asterisk"}.}
    \item{\code{pairwise.display}}{Decides which pairwise comparisons to display.
Available options are \code{"significant"} (abbreviation accepted: \code{"s"}) or
\code{"non-significant"} (abbreviation accepted: \code{"ns"}) or
\code{"everything"}/\code{"all"}. The default is \code{"significant"}. You can use this
argument to make sure that your plot is not uber-cluttered when you have
multiple groups being compared and scores of pairwise comparisons being
displayed.}
    \item{\code{p.adjust.method}}{Adjustment method for \emph{p}-values for multiple
comparisons. Possible methods are: \code{"holm"} (default), \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.}
    \item{\code{effsize.type}}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"biased"} (equivalent to \code{"d"} for Cohen's \emph{d} for
\strong{t-test}; \code{"partial_eta"} for partial eta-squared for \strong{anova}) or
\code{"unbiased"} (equivalent to \code{"g"} Hedge's \emph{g} for \strong{t-test};
\code{"partial_omega"} for partial omega-squared for \strong{anova})).}
    \item{\code{partial}}{If \code{TRUE}, return partial indices.}
    \item{\code{bf.prior}}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}
    \item{\code{bf.message}}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}
    \item{\code{results.subtitle}}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}
    \item{\code{xlab}}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}
    \item{\code{ylab}}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}
    \item{\code{caption}}{The text for the plot caption.}
    \item{\code{subtitle}}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}
    \item{\code{sample.size.label}}{Logical that decides whether sample size information
should be displayed for each level of the grouping variable \code{x} (Default:
\code{TRUE}).}
    \item{\code{k}}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}
    \item{\code{conf.level}}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}
    \item{\code{nboot}}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}
    \item{\code{tr}}{Trim level for the mean when carrying out \code{robust} tests. If you
get error stating "Standard error cannot be computed because of Winsorized
variance of 0 (e.g., due to ties). Try to decrease the trimming level.",
try to play around with the value of \code{tr}, which is by default set to
\code{0.1}. Lowering the value might help.}
    \item{\code{mean.plotting}}{Logical that decides whether mean is to be highlighted
and its value to be displayed (Default: \code{TRUE}).}
    \item{\code{mean.ci}}{Logical that decides whether \verb{95\%} confidence interval for
mean is to be displayed (Default: \code{FALSE}).}
    \item{\code{mean.point.args}}{A list of additional aesthetic
arguments to be passed to \code{ggplot2::geom_point} and
\code{ggrepel::geom_label_repel} geoms involved mean value plotting.}
    \item{\code{mean.label.args}}{A list of additional aesthetic
arguments to be passed to \code{ggplot2::geom_point} and
\code{ggrepel::geom_label_repel} geoms involved mean value plotting.}
    \item{\code{notch}}{A logical. If \code{FALSE} (default), a standard box plot will be
displayed. If \code{TRUE}, a notched box plot will be used. Notches are used to
compare groups; if the notches of two boxes do not overlap, this suggests
that the medians are significantly different. In a notched box plot, the
notches extend \code{1.58 * IQR / sqrt(n)}. This gives a roughly \verb{95\%}
confidence interval for comparing medians. IQR: Inter-Quartile Range.}
    \item{\code{notchwidth}}{For a notched box plot, width of the notch relative to the
body (default \code{0.5}).}
    \item{\code{outlier.tagging}}{Decides whether outliers should be tagged (Default:
\code{FALSE}).}
    \item{\code{outlier.coef}}{Coefficient for outlier detection using Tukey's method.
With Tukey's method, outliers are below (1st Quartile) or above (3rd
Quartile) \code{outlier.coef} times the Inter-Quartile Range (IQR) (Default:
\code{1.5}).}
    \item{\code{outlier.label.args}}{A list of additional aesthetic arguments to be
passed to \code{ggplot2::geom_point} and \code{ggrepel::geom_label_repel} geoms
involved outlier value plotting.}
    \item{\code{outlier.point.args}}{A list of additional aesthetic arguments to be
passed to \code{ggplot2::geom_point} and \code{ggrepel::geom_label_repel} geoms
involved outlier value plotting.}
    \item{\code{violin.args}}{A list of additional aesthetic arguments to be passed to
the \code{geom_violin}.}
    \item{\code{ggtheme}}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_fivethirtyeight()},
\code{hrbrthemes::theme_ipsum_ps()}, etc.).}
    \item{\code{ggstatsplot.layer}}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}). \code{theme_ggstatsplot} is an opinionated theme layer that
override some aspects of the selected \code{ggtheme}.}
    \item{\code{package}}{Name of package from which the palette is desired as string
or symbol.}
    \item{\code{palette}}{Name of palette as string or symbol.}
    \item{\code{direction}}{Either \code{1} or \code{-1}. If \code{-1} the palette will be reversed.}
    \item{\code{ggplot.component}}{A \code{ggplot} component to be added to the plot prepared
by \code{ggstatsplot}. This argument is primarily helpful for \code{grouped_} variant
of the current function. Default is \code{NULL}. The argument should be entered
as a function.}
    \item{\code{messages}}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
    \item{\code{sphericity.correction}}{Logical that decides whether to apply correction
to account for violation of sphericity in a repeated measures design ANOVA
(Default: \code{TRUE}).}
  }}

\item{plotgrid.args}{A list of additional arguments to \code{cowplot::plot_grid}.}

\item{title.text}{String or plotmath expression to be drawn as title for the
\emph{combined plot}.}

\item{title.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}

\item{caption.text}{String or plotmath expression to be drawn as the caption
for the \emph{combined plot}.}

\item{caption.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}

\item{sub.text}{The label with which the \emph{combined plot} should be annotated.
Can be a plotmath expression.}

\item{sub.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}
}
\description{
A combined plot of comparison plot created for levels of a
grouping variable.
}
\details{
For more about how the effect size measures (for nonparametric tests) and
their confidence intervals are computed, see \code{?rcompanion::wilcoxonPairedR}.

For independent measures designs, use \code{ggbetweenstats}.
}
\examples{
\donttest{
# to get reproducible results from bootstrapping
set.seed(123)
library(ggstatsplot)

# the most basic function call
ggstatsplot::grouped_ggwithinstats(
  data = VR_dilemma,
  x = modality,
  y = score,
  grouping.var = order,
  ggplot.component = ggplot2::scale_y_continuous(
    breaks = seq(0, 1, 0.1),
    limits = c(0, 1)
  ),
  messages = TRUE
)
}
}
\seealso{
\code{\link{ggwithinstats}}, \code{\link{ggbetweenstats}},
\code{\link{grouped_ggbetweenstats}}
}
