% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{population_german_states}
\alias{population_german_states}
\title{Population of the German states (2023)}
\format{
A data frame with 2912 rows and 5 columns:
\describe{
\item{reporting_date}{Date: Always "2023-12-31"}
\item{state}{Character: Name of the German state}
\item{age}{Numeric: Age from 0 to 89. Age 90 includes "90 and above"}
\item{sex}{Factor: "female" or "male"}
\item{n}{Numeric: Population size}
}
}
\source{
© Statistisches Bundesamt (Destatis), Genesis-Online, 2025:
Bevölkerung: Bundesländer, Stichtag, Geschlecht, Altersjahre (12411-0013).
Data licence Germany (\href{https://www.govdata.de/dl-de/by-2-0}{dl-de/by-2-0})
\url{https://www-genesis.destatis.de/datenbank/online/statistic/12411/table/12411-0013}
}
\usage{
population_german_states
}
\description{
German Population data by state in 2023
}
\examples{
# Age pyramid
library(ggplot2)
library(dplyr)
population_german_states |>
  filter(age < 90) |>
  ggplot(aes(y = age, fill = sex, weight = n)) +
  geom_bar_diverging(width = 1) +
  geom_vline(xintercept = 0) +
  scale_x_continuous_diverging() +
  facet_wrap(~state, scales = "free_x") +
  theme_bw(base_size = 8) +
  theme_mod_legend_top()
}
\keyword{datasets}
