% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tern-limits.R
\name{tern_limits}
\alias{limit_tern}
\alias{limits_tern}
\alias{tern_limit}
\alias{tern_limits}
\title{Restrict Ternary Limits}
\usage{
tern_limits(T = 1, L = 1, R = 1, ...)

limits_tern(...)

limit_tern(...)

tern_limit(...)
}
\arguments{
\item{T, L, R}{numeric value (scalar) of the maximum \code{T,L,R} species limit for each scale respectively}

\item{...}{other arguments to pass to ALL of \code{scale_X_continuous} (\code{X = T, L, R})}
}
\value{
Either an empty list (when no solution can be found), or a list containing one of each 
of \code{scale_X_continuous} (\code{X = T, L, R})
}
\description{
\code{tern_limits} (or its aliasses) appends new \code{T}, \code{L} and \code{R} ternary continuous scales, 
where the maximum scale value is specified, and, where the minimums for each are solved.
}
\details{
The contra value (ie minimum value) for the \code{T}, \code{L} and \code{R} species is solved using
linear equations, therefore, if the solution is degenerate, or, the solution results in a zero range in either
of the proposed scales, then a warning message will be reported and an empty list returned. Note that 
\code{limits_tern(\dots), limit_tern(\dots)} and \code{tern_limit(\dots)} are all aliasses for 
the main function, \code{tern_limits(\dots)} and can be used interchangeably.
}
\examples{
df = data.frame(x=runif(10),y=runif(10),z=runif(10))
ggtern(df,aes(x,y,z)) + geom_point() + tern_limits(0.7,0.3,0.4)
}
\author{
Nicholas Hamilton
}
\seealso{
\code{\link{scale_T_continuous}}, \code{\link{scale_L_continuous}} and \code{\link{scale_R_continuous}}
}

