% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapes.R
\name{scale_shape_tremmel}
\alias{scale_shape_tremmel}
\title{Shape scales from Tremmel (1995)}
\usage{
scale_shape_tremmel(overlap = FALSE, n3alt = TRUE, ...)
}
\arguments{
\item{overlap}{use an empty circle instead of a solid circle when
\code{n == 2}.}

\item{n3alt}{If \code{TRUE} then use a solid circle, plus sign and
empty triangle, else use a solid circle, empty circle, and empty
triangle.}

\item{...}{common discrete scale parameters: \code{name}, \code{breaks},
\code{labels}, \code{na.value}, \code{limits} and \code{guide}.  See
\code{\link{discrete_scale}} for more details}
}
\description{
Shape scales from Tremmel (1995)
}
\examples{
library("ggplot2")
(ggplot(mtcars, aes(x=mpg, y=hp, shape=factor(cyl)))
 + geom_point() + scale_shape_tremmel())
(ggplot(mtcars, aes(x=mpg, y=hp, shape=factor(cyl)))
 + geom_point() + scale_shape_tremmel(n3alt=FALSE))
(ggplot(mtcars, aes(x=mpg, y=hp, shape=factor(am)))
 + geom_point() + scale_shape_tremmel())
(ggplot(mtcars, aes(x=mpg, y=hp, shape=factor(am)))
 + geom_point() + scale_shape_tremmel(overlap=TRUE))
}
\seealso{
\code{\link{tremmel_shape_pal}} for a description of the palette.

Other shapes: \code{\link{circlefill_shape_pal}},
  \code{\link{cleveland_shape_pal}},
  \code{\link{scale_shape_circlefill}},
  \code{\link{scale_shape_cleveland}},
  \code{\link{tremmel_shape_pal}}
}

