% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr.R
\name{dplyr-ggvis}
\alias{dplyr-ggvis}
\alias{groups.ggvis}
\alias{group_by_.ggvis}
\alias{ungroup.ggvis}
\alias{summarise_.ggvis}
\alias{mutate_.ggvis}
\alias{arrange_.ggvis}
\alias{select_.ggvis}
\alias{filter_.ggvis}
\alias{distinct_.ggvis}
\alias{slice_.ggvis}
\alias{rename_.ggvis}
\alias{transmute_.ggvis}
\alias{groups.reactive}
\alias{ungroup.reactive}
\alias{group_by_.reactive}
\alias{summarise_.reactive}
\alias{mutate_.reactive}
\alias{arrange_.reactive}
\alias{select_.reactive}
\alias{filter_.reactive}
\alias{distinct_.reactive}
\alias{slice_.reactive}
\alias{rename_.reactive}
\alias{transmute_.reactive}
\title{Dplyr verbs for ggvis.}
\usage{
\method{groups}{ggvis}(x)

\method{group_by_}{ggvis}(.data, ..., .dots, add = FALSE)

\method{ungroup}{ggvis}(x)

\method{summarise_}{ggvis}(.data, ..., .dots)

\method{mutate_}{ggvis}(.data, ..., .dots)

\method{arrange_}{ggvis}(.data, ..., .dots)

\method{select_}{ggvis}(.data, ..., .dots)

\method{filter_}{ggvis}(.data, ..., .dots)

\method{distinct_}{ggvis}(.data, ..., .dots)

\method{slice_}{ggvis}(.data, ..., .dots)

\method{rename_}{ggvis}(.data, ..., .dots)

\method{transmute_}{ggvis}(.data, ..., .dots)

\method{groups}{reactive}(x)

\method{ungroup}{reactive}(x)

\method{group_by_}{reactive}(.data, ..., .dots, add = FALSE)

\method{summarise_}{reactive}(.data, ..., .dots)

\method{mutate_}{reactive}(.data, ..., .dots)

\method{arrange_}{reactive}(.data, ..., .dots)

\method{select_}{reactive}(.data, ..., .dots)

\method{filter_}{reactive}(.data, ..., .dots)

\method{distinct_}{reactive}(.data, ..., .dots)

\method{slice_}{reactive}(.data, ..., .dots)

\method{rename_}{reactive}(.data, ..., .dots)

\method{transmute_}{reactive}(.data, ..., .dots)
}
\description{
Applying a dplyr verb to a ggvis object creates a reactive transformation:
whenever the underlying data changes the transformation will be recomputed.
}
\section{Non-standard evaluation}{

Both dplyr and shiny do non-standard evaluation, so to help each package
figure out when it should evaluate its code, reactive components in
these functions must be wrapped in \code{eval()}.
}

\examples{
library(dplyr)
base <- mtcars \%>\% ggvis(~mpg, ~cyl) \%>\% layer_points()
base \%>\% group_by(cyl) \%>\% summarise(mpg = mean(mpg)) \%>\%
  layer_points(fill := "red", size := 100)

base \%>\% filter(mpg > 25) \%>\% layer_points(fill := "red")

base \%>\% mutate(cyl = jitter(cyl)) \%>\% layer_points(fill := "red")

\dontrun{
# Dynamically restrict range using filter
mtcars \%>\% ggvis(~disp, ~mpg) \%>\%
   filter(cyl > eval(input_slider(0, 10))) \%>\%
   layer_points()

# Dynamically compute box-cox transformation with mutate
bc <- function(x, lambda) {
  if (abs(lambda) < 1e-6) log(x) else (x ^ lambda - 1) / lambda
}
bc_slider <- input_slider(-2, 2, 1, step = 0.1)
mtcars \%>\%
 ggvis(~disp, ~mpg) \%>\%
 mutate(disp = bc(disp, eval(bc_slider))) \%>\%
 layer_points()
}
}
\keyword{internal}
