% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/blob.r
\docType{methods}
\name{show,git_blob-method}
\alias{show,git_blob-method}
\alias{show,git_blob-methods}
\title{Brief summary of blob}
\usage{
\S4method{show}{git_blob}(object)
}
\arguments{
\item{object}{The blob \code{object}}
}
\value{
None (invisible 'NULL').
}
\description{
Brief summary of blob
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Brief summary of the blob in the repository
tree(commits(repo)[[1]])["example.txt"]
}
}
\keyword{methods}

