% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/querygkg.R
\name{querygkg}
\alias{querygkg}
\title{Performs a query on the Google Knowledge Graph API}
\usage{
querygkg(
  query = NULL,
  ids = NULL,
  lang = NULL,
  types = NULL,
  indent = NULL,
  prefix = NULL,
  limit = NULL,
  json = FALSE,
  itemList = TRUE,
  api.key
)
}
\arguments{
\item{query}{A character string to search for in Google Knowledge Graph.}

\item{ids}{A list of one or more entity IDs to search for in Google Knowledge Graph. Should be a Google Knowledge Graph or Freebase ID code in character string format.}

\item{lang}{A character argument defining the language filter. The list of language codes (defined in ISO 639) to run the query with, for instance `en`. Defaults to NULL.}

\item{types}{A character argument restricting returned entities to those of the specified types. See schema.org for valid types (e.g. `Person` as defined in http://schema.org/Person restricts the results to entities representing people). If multiple types are specified, returned entities will contain one or more of these types. Defaults to NULL.}

\item{indent}{A logical argument enabling indenting of JSON results. Defaults to NULL.}

\item{prefix}{A logical argument enabling prefix (initial substring) matching against names and aliases of entities. For example, a prefix `Jung` will match entities and aliases such as `Jung`, `Jungle`, and `Jung-ho Kang`. Defaults to NULL.}

\item{limit}{A numeric value limiting the number of entities to be returned. Maximum is 500. Defaults to 20. Please note that requests with high limits have a higher chance of timing out.}

\item{json}{A logical argument defining whether the API query should be returned in the original JSON format or as an R object. Defaults to FALSE.}

\item{itemList}{Should the query contain only the Google Knowledge Graph item list returned by the query? Defaults to TRUE. Only valid when returning R objects (i.e. parameter json = FALSE).}

\item{api.key}{A Google API key.}
}
\value{
Returns the Google Knowledge Graph output.
}
\description{
Performs a query on the Google Knowledge Graph API
}
\examples{
\dontrun{
# Note: Function querygkg requires a valid Google API key to work

# Run a text-based query for the term "apple"
querygkg(query = "apple", api.key = "YOUR_API_KEY")

# Run an ID-based query for the entity "apple" representing the fruit
querygkg(ids = "/m/014j1m", api.key = "YOUR_API_KEY")

# Run an ID-based query and get the original JSON object returned by the API
querygkg(ids = "/m/014j1m", json = TRUE, api.key = "YOUR_API_KEY")
}
}
