% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-other-methods.R
\name{response}
\alias{response}
\alias{response.gkwreg}
\title{Extract Response Variable from GKw Regression Model}
\usage{
response(object, ...)

\method{response}{gkwreg}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"gkwreg"}.}

\item{...}{Currently not used.}
}
\value{
A numeric vector containing the response variable values.
}
\description{
Extracts the response variable from a fitted Generalized Kumaraswamy
regression model object.
}
\examples{
\donttest{
data(GasolineYield)
fit <- gkwreg(yield ~ batch + temp, data = GasolineYield, family = "kw")
y <- response(fit)
head(y)
}

}
\seealso{
\code{\link{gkwreg}}, \code{\link{fitted.gkwreg}}, \code{\link{residuals.gkwreg}}
}
\author{
Lopes, J. E.
}
