% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glamlasso_print.R
\name{print.glamlasso}
\alias{print.glamlasso}
\title{Print Function for objects of Class glamlasso}
\usage{
\method{print}{glamlasso}(x, ...)
}
\arguments{
\item{x}{A glamlasso object}

\item{...}{ignored}
}
\description{
This function will print some information about the glamlasso object.
}
\examples{
 
\dontrun{
n1 <- 65; n2 <- 26; n3 <- 13; p1 <- 13; p2 <- 5; p3 <- 4
X1 <- matrix(rnorm(n1 * p1), n1, p1) 
X2 <- matrix(rnorm(n2 * p2), n2, p2) 
X3 <- matrix(rnorm(n3 * p3), n3, p3) 
Beta <- array(rnorm(p1 * p2 * p3) * rbinom(p1 * p2 * p3, 1, 0.1), c(p1 , p2, p3))
mu <- RH(X3, RH(X2, RH(X1, Beta)))
Y <- array(rnorm(n1 * n2 * n3, mu), dim = c(n1, n2, n3))
fit <- glamlasso(list(X1, X2, X3), Y, family = "gaussian", penalty = "lasso", iwls = "exact")
fit
}

}
\author{
Adam Lund
}
