% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GlmBayesMfpSamples-class.R
\docType{class}
\name{GlmBayesMfpSamples-class}
\alias{GlmBayesMfpSamples-class}
\title{Class for samples from a single GlmBayesMfp model or a model average}
\description{
Class for samples from a single GlmBayesMfp model or a model average
}
\note{
Note that for a model average, \code{nSamples} will typically *not*
be the number of samples available for each bfp curve, e.g.

\describe{ 
\item{fitted}{fit samples on the linear predictor scale (\code{nObs} x
\code{nSamples})}
\item{predictions}{samples from the predictive distribution for new data
on the linear predictor scale, if \code{newdata} was provided
(\code{nrow(newdata)} x \code{nSamples})}
\item{fixCoefs}{the intercept and fixed covariate samples}
\item{z}{the log covariance factor samples}
\item{bfpCurves}{samples of fractional polynomial function values evaluated at
grids, contains one list element for each FP. Each element is
a matrix with the layout \code{nGridPoints x nSamples}.}
\item{ucCoefs}{uncertain fixed form covariates coefficients samples,
contains one list element for each fixed form covariate group.
Each element is a matrix with the layout \code{nCoefs x nSamples}.}
\item{shiftScaleMax}{transformation parameters}
\item{nSamples}{number of samples}
}
}
\keyword{classes}
\keyword{internal}

